/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.JmeSystem;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.SafeArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScreenshotAppState
extends AbstractAppState
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ScreenshotAppState.class.getName());
    private Application app;
    private String filePath = null;
    private boolean capture = false;
    private boolean numbered = true;
    private ByteBuffer outBuf;
    private String shotName;
    private long shotIndex = 0L;
    private int width;
    private int height;
    private InputManager inputManager;
    private ViewPort last;
    private ScreenShotProcessor screenShotProcessor = new ScreenShotProcessor();
    private SafeArrayList<Consumer> listeners = new SafeArrayList<Consumer>(Consumer.class);

    public ScreenshotAppState() {
        this(null);
    }

    public ScreenshotAppState(String filePath) {
        this.filePath = filePath;
    }

    public ScreenshotAppState(String filePath, String fileName) {
        this.filePath = filePath;
        this.shotName = fileName;
    }

    public ScreenshotAppState(String filePath, long shotIndex) {
        this.filePath = filePath;
        this.shotIndex = shotIndex;
    }

    public ScreenshotAppState(String filePath, String fileName, long shotIndex) {
        this.filePath = filePath;
        this.shotName = fileName;
        this.shotIndex = shotIndex;
    }

    public void addCaptureListener(Consumer<CaptureInfo> listener) {
        this.listeners.add(listener);
    }

    public void removeCaptureListener(Consumer<CaptureInfo> listener) {
        this.listeners.remove(listener);
    }

    public ScreenshotAppState onCapture(Consumer<CaptureInfo> listener) {
        this.addCaptureListener(listener);
        return this;
    }

    protected void notifyListeners(CaptureInfo capInfo) {
        for (Consumer c : this.listeners.getArray()) {
            c.accept(capInfo);
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFileName(String fileName) {
        this.shotName = fileName;
    }

    public void setShotIndex(long index) {
        this.shotIndex = index;
    }

    public void setIsNumbered(boolean numberedWanted) {
        this.numbered = numberedWanted;
    }

    public void resetViewPort() {
        List<ViewPort> vps = this.app.getRenderManager().getPostViews();
        for (int i = vps.size() - 1; i >= 0; --i) {
            ViewPort vp = vps.get(i);
            if (!vp.isEnabled()) continue;
            this.setLastViewPort(vp);
            break;
        }
    }

    protected void setLastViewPort(ViewPort last) {
        logger.info("setLastViewPort(" + last + ")");
        if (this.last == last) {
            return;
        }
        if (this.last != null) {
            ViewPort viewPort = this.last;
            viewPort.removeProcessor(this.screenShotProcessor);
            logger.info(" removed from:" + viewPort);
        }
        this.last = last;
        if (last != null) {
            this.capture = false;
            last.addProcessor(this.screenShotProcessor);
            logger.info(" added to:" + last);
        }
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        this.app = app;
        if (!super.isInitialized()) {
            this.inputManager = app.getInputManager();
            this.inputManager.addMapping("ScreenShot", new KeyTrigger(183));
            this.inputManager.addListener(this, "ScreenShot");
            this.resetViewPort();
            if (this.shotName == null) {
                this.shotName = app.getClass().getSimpleName();
            }
        }
        super.initialize(stateManager, app);
    }

    @Override
    public void cleanup() {
        if (this.inputManager != null) {
            this.inputManager.deleteMapping("ScreenShot");
            this.inputManager.removeListener(this);
            this.inputManager = null;
        }
        this.setLastViewPort(null);
        super.cleanup();
    }

    @Override
    public void onAction(String name, boolean value, float tpf) {
        if (value) {
            this.capture = true;
        }
    }

    public void takeScreenshot() {
        this.capture = true;
    }

    protected void writeImageFile(File file) throws IOException {
        try (FileOutputStream outStream = new FileOutputStream(file);){
            JmeSystem.writeImageFile(outStream, "png", this.outBuf, this.width, this.height);
        }
    }

    private class ScreenShotProcessor
    implements SceneProcessor {
        private Renderer renderer;
        private RenderManager rm;

        private ScreenShotProcessor() {
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void initialize(RenderManager rm, ViewPort vp) {
            this.renderer = rm.getRenderer();
            this.rm = rm;
            this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
        }

        @Override
        public boolean isInitialized() {
            return this.renderer != null;
        }

        @Override
        public void postFrame(FrameBuffer out) {
            String filename;
            if (!ScreenshotAppState.this.capture) {
                return;
            }
            ScreenshotAppState.this.capture = false;
            if (ScreenshotAppState.this.numbered) {
                ScreenshotAppState.this.shotIndex++;
                filename = ScreenshotAppState.this.shotName + ScreenshotAppState.this.shotIndex;
            } else {
                filename = ScreenshotAppState.this.shotName;
            }
            File file = ScreenshotAppState.this.filePath == null ? new File(JmeSystem.getStorageFolder() + File.separator + filename + ".png").getAbsoluteFile() : new File(ScreenshotAppState.this.filePath + filename + ".png").getAbsoluteFile();
            Camera curCamera = this.rm.getCurrentCamera();
            int viewX = (int)(curCamera.getViewPortLeft() * (float)curCamera.getWidth());
            int viewY = (int)(curCamera.getViewPortBottom() * (float)curCamera.getHeight());
            int viewWidth = (int)((curCamera.getViewPortRight() - curCamera.getViewPortLeft()) * (float)curCamera.getWidth());
            int viewHeight = (int)((curCamera.getViewPortTop() - curCamera.getViewPortBottom()) * (float)curCamera.getHeight());
            this.renderer.setViewPort(0, 0, ScreenshotAppState.this.width, ScreenshotAppState.this.height);
            this.renderer.readFrameBuffer(out, ScreenshotAppState.this.outBuf);
            ScreenshotAppState.this.notifyListeners(new CaptureInfo(ScreenshotAppState.this, file, curCamera, this.renderer, out, ScreenshotAppState.this.outBuf, ScreenshotAppState.this.last));
            this.renderer.setViewPort(viewX, viewY, viewWidth, viewHeight);
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Saving ScreenShot to: {0}", file.getAbsolutePath());
            }
            try {
                ScreenshotAppState.this.writeImageFile(file);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while saving screenshot", ex);
            }
        }

        @Override
        public void postQueue(RenderQueue rq) {
        }

        @Override
        public void preFrame(float tpf) {
        }

        @Override
        public void reshape(ViewPort vp, int w, int h) {
            ScreenshotAppState.this.outBuf = BufferUtils.createByteBuffer(w * h * 4);
            ScreenshotAppState.this.width = w;
            ScreenshotAppState.this.height = h;
        }

        @Override
        public void setProfiler(AppProfiler profiler) {
        }
    }

    public static class CaptureInfo {
        private final ScreenshotAppState state;
        private final File file;
        private final Camera camera;
        private final Renderer renderer;
        private final FrameBuffer frameBuff;
        private final ByteBuffer output;
        private final ViewPort viewPort;

        protected CaptureInfo(ScreenshotAppState state, File file, Camera camera, Renderer renderer, FrameBuffer frameBuff, ByteBuffer output, ViewPort viewPort) {
            this.state = state;
            this.file = file;
            this.camera = camera;
            this.renderer = renderer;
            this.frameBuff = frameBuff;
            this.output = output;
            this.viewPort = viewPort;
        }

        public ScreenshotAppState getState() {
            return this.state;
        }

        public File getFile() {
            return this.file;
        }

        public Camera getCamera() {
            return this.camera;
        }

        public Renderer getRenderer() {
            return this.renderer;
        }

        public FrameBuffer getFrameBuffer() {
            return this.frameBuff;
        }

        public ByteBuffer getOutputBuffer() {
            return this.output;
        }

        public ViewPort getViewPort() {
            return this.viewPort;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.file + "]";
        }
    }
}

