/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.util;

import com.jme3.asset.AssetManager;
import com.jme3.environment.util.CubeMapWrapper;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.image.ColorSpace;
import com.jme3.ui.Picture;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.nio.ByteBuffer;

public class EnvMapUtils {
    private static final float sqrtPi = FastMath.sqrt((float)Math.PI);
    private static final float sqrt3Pi = FastMath.sqrt(0.95492965f);
    private static final float sqrt5Pi = FastMath.sqrt(1.5915494f);
    private static final float sqrt15Pi = FastMath.sqrt(4.774648f);
    public static final int NUM_SH_COEFFICIENT = 9;
    public static float[] shBandFactor = new float[]{1.0f, 0.6666667f, 0.6666667f, 0.6666667f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f};

    private EnvMapUtils() {
    }

    public static TextureCubeMap makeCubeMap(Image rightImg, Image leftImg, Image upImg, Image downImg, Image backImg, Image frontImg, Image.Format format) {
        Image cubeImage = new Image(format, leftImg.getWidth(), leftImg.getHeight(), null, ColorSpace.Linear);
        cubeImage.addData(rightImg.getData(0));
        cubeImage.addData(leftImg.getData(0));
        cubeImage.addData(upImg.getData(0));
        cubeImage.addData(downImg.getData(0));
        cubeImage.addData(backImg.getData(0));
        cubeImage.addData(frontImg.getData(0));
        cubeImage.setMipMapSizes(rightImg.getMipMapSizes());
        TextureCubeMap cubeMap = new TextureCubeMap(cubeImage);
        cubeMap.setAnisotropicFilter(0);
        cubeMap.setMagFilter(Texture.MagFilter.Bilinear);
        cubeMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
        cubeMap.setWrap(Texture.WrapMode.EdgeClamp);
        return cubeMap;
    }

    public static TextureCubeMap duplicateCubeMap(TextureCubeMap sourceMap) {
        Image srcImg = sourceMap.getImage();
        Image cubeImage = new Image(srcImg.getFormat(), srcImg.getWidth(), srcImg.getHeight(), null, srcImg.getColorSpace());
        for (ByteBuffer d : srcImg.getData()) {
            cubeImage.addData(d.duplicate());
        }
        cubeImage.setMipMapSizes(srcImg.getMipMapSizes());
        TextureCubeMap cubeMap = new TextureCubeMap(cubeImage);
        cubeMap.setAnisotropicFilter(sourceMap.getAnisotropicFilter());
        cubeMap.setMagFilter(sourceMap.getMagFilter());
        cubeMap.setMinFilter(sourceMap.getMinFilter());
        cubeMap.setWrap(sourceMap.getWrap(Texture.WrapAxis.S));
        return cubeMap;
    }

    static float getSolidAngleAndVector(int x, int y, int mapSize, int face, Vector3f store, FixSeamsMethod fixSeamsMethod) {
        if (store == null) {
            throw new IllegalArgumentException("the store parameter must not be null");
        }
        float u = 2.0f * ((float)x + 0.5f) / (float)mapSize - 1.0f;
        float v = 2.0f * ((float)y + 0.5f) / (float)mapSize - 1.0f;
        EnvMapUtils.getVectorFromCubemapFaceTexCoord(x, y, mapSize, face, store, fixSeamsMethod);
        float invRes = 1.0f / (float)mapSize;
        float x0 = u - invRes;
        float y0 = v - invRes;
        float x1 = u + invRes;
        float y1 = v + invRes;
        return EnvMapUtils.areaElement(x0, y0) - EnvMapUtils.areaElement(x0, y1) - EnvMapUtils.areaElement(x1, y0) + EnvMapUtils.areaElement(x1, y1);
    }

    private static float areaElement(float x, float y) {
        return (float)Math.atan2(x * y, FastMath.sqrt(x * x + y * y + 1.0f));
    }

    public static Vector3f getVectorFromCubemapFaceTexCoord(int x, int y, int mapSize, int face, Vector3f store, FixSeamsMethod fixSeamsMethod) {
        float v;
        float u;
        if (store == null) {
            store = new Vector3f();
        }
        if (fixSeamsMethod == FixSeamsMethod.Stretch) {
            u = 2.0f * (float)x / ((float)mapSize - 1.0f) - 1.0f;
            v = 2.0f * (float)y / ((float)mapSize - 1.0f) - 1.0f;
        } else {
            u = 2.0f * ((float)x + 0.5f) / (float)mapSize - 1.0f;
            v = 2.0f * ((float)y + 0.5f) / (float)mapSize - 1.0f;
        }
        if (fixSeamsMethod == FixSeamsMethod.Wrap) {
            float a = FastMath.pow(mapSize, 2.0f) / FastMath.pow((float)mapSize - 1.0f, 3.0f);
            u = a * FastMath.pow(u, 3.0f) + u;
            v = a * FastMath.pow(v, 3.0f) + v;
        }
        switch (face) {
            case 0: {
                store.set(1.0f, -v, -u);
                break;
            }
            case 1: {
                store.set(-1.0f, -v, u);
                break;
            }
            case 2: {
                store.set(u, 1.0f, v);
                break;
            }
            case 3: {
                store.set(u, -1.0f, -v);
                break;
            }
            case 4: {
                store.set(u, -v, 1.0f);
                break;
            }
            case 5: {
                store.set(-u, -v, -1.0f);
            }
        }
        return store.normalizeLocal();
    }

    public static int getCubemapFaceTexCoordFromVector(Vector3f texelVect, int mapSize, Vector2f store, FixSeamsMethod fixSeamsMethod) {
        float u = 0.0f;
        float v = 0.0f;
        float bias = 0.0f;
        float absX = FastMath.abs(texelVect.x);
        float absY = FastMath.abs(texelVect.y);
        float absZ = FastMath.abs(texelVect.z);
        float max = Math.max(Math.max(absX, absY), absZ);
        int face = max == absX ? (texelVect.x > 0.0f ? 0 : 1) : (max == absY ? (texelVect.y > 0.0f ? 2 : 3) : (texelVect.z > 0.0f ? 4 : 5));
        switch (face) {
            case 0: {
                bias = 1.0f / texelVect.x;
                u = -texelVect.z;
                v = -texelVect.y;
                break;
            }
            case 1: {
                bias = -1.0f / texelVect.x;
                u = texelVect.z;
                v = -texelVect.y;
                break;
            }
            case 2: {
                bias = 1.0f / texelVect.y;
                u = texelVect.x;
                v = texelVect.z;
                break;
            }
            case 3: {
                bias = -1.0f / texelVect.y;
                u = texelVect.x;
                v = -texelVect.z;
                break;
            }
            case 4: {
                bias = 1.0f / texelVect.z;
                u = texelVect.x;
                v = -texelVect.y;
                break;
            }
            case 5: {
                bias = -1.0f / texelVect.z;
                u = -texelVect.x;
                v = -texelVect.y;
            }
        }
        u *= bias;
        v *= bias;
        if (fixSeamsMethod == FixSeamsMethod.Stretch) {
            u = Math.round((u + 1.0f) * ((float)mapSize - 1.0f) * 0.5f);
            v = Math.round((v + 1.0f) * ((float)mapSize - 1.0f) * 0.5f);
        } else {
            u = Math.round((u + 1.0f) * (float)mapSize * 0.5f - 0.5f);
            v = Math.round((v + 1.0f) * (float)mapSize * 0.5f - 0.5f);
        }
        store.set(u, v);
        return face;
    }

    public static int getSampleFromMip(int mipLevel, int miptot) {
        return mipLevel == 0 ? 1 : Math.min(1 << miptot - 1 + mipLevel * 2, 8192);
    }

    public static float getRoughnessFromMip(int miplevel, int miptot) {
        float step = 1.0f / ((float)miptot - 1.0f);
        return (step *= (float)miplevel) * step;
    }

    public static float getMipFromRoughness(float roughness, int miptot) {
        return FastMath.sqrt(roughness) * (float)(miptot - 1);
    }

    public static Vector3f[] getSphericalHarmonicsCoefficents(TextureCubeMap cubeMap) {
        return EnvMapUtils.getSphericalHarmonicsCoefficents(cubeMap, FixSeamsMethod.Wrap);
    }

    public static Vector3f[] getSphericalHarmonicsCoefficents(TextureCubeMap cubeMap, FixSeamsMethod fixSeamsMethod) {
        Vector3f[] shCoef = new Vector3f[9];
        float[] shDir = new float[9];
        float weightAccum = 0.0f;
        if (cubeMap.getImage().getData(0) == null) {
            throw new IllegalStateException("The cube map must contain Efficient data, if you rendered the cube map on the GPU please use renderer.readFrameBuffer, to create a CPU image");
        }
        int width = cubeMap.getImage().getWidth();
        int height = cubeMap.getImage().getHeight();
        Vector3f texelVect = new Vector3f();
        ColorRGBA color = new ColorRGBA();
        CubeMapWrapper envMapReader = new CubeMapWrapper(cubeMap);
        for (int face = 0; face < 6; ++face) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float weight = EnvMapUtils.getSolidAngleAndVector(x, y, width, face, texelVect, fixSeamsMethod);
                    EnvMapUtils.evalShBasis(texelVect, shDir);
                    envMapReader.getPixel(x, y, face, color);
                    for (int i = 0; i < 9; ++i) {
                        if (shCoef[i] == null) {
                            shCoef[i] = new Vector3f();
                        }
                        shCoef[i].setX(shCoef[i].x + color.r * shDir[i] * weight);
                        shCoef[i].setY(shCoef[i].y + color.g * shDir[i] * weight);
                        shCoef[i].setZ(shCoef[i].z + color.b * shDir[i] * weight);
                    }
                    weightAccum += weight;
                }
            }
        }
        for (int i = 0; i < 9; ++i) {
            shCoef[i].multLocal((float)Math.PI * 4 / weightAccum);
        }
        return shCoef;
    }

    public static void evalShBasis(Vector3f texelVect, float[] shDir) {
        float xV = texelVect.x;
        float yV = texelVect.y;
        float zV = texelVect.z;
        float x2 = xV * xV;
        float y2 = yV * yV;
        float z2 = zV * zV;
        shDir[0] = 1.0f / (2.0f * sqrtPi);
        shDir[1] = -(sqrt3Pi * yV) / 2.0f;
        shDir[2] = sqrt3Pi * zV / 2.0f;
        shDir[3] = -(sqrt3Pi * xV) / 2.0f;
        shDir[4] = sqrt15Pi * xV * yV / 2.0f;
        shDir[5] = -(sqrt15Pi * yV * zV) / 2.0f;
        shDir[6] = sqrt5Pi * (-1.0f + 3.0f * z2) / 4.0f;
        shDir[7] = -(sqrt15Pi * xV * zV) / 2.0f;
        shDir[8] = sqrt15Pi * (x2 - y2) / 4.0f;
    }

    public static void prepareShCoefs(Vector3f[] shCoefs) {
        float coef0 = 1.0f / (2.0f * sqrtPi);
        float coef1 = -sqrt3Pi / 2.0f;
        float coef2 = -coef1;
        float coef3 = coef1;
        float coef4 = sqrt15Pi / 2.0f;
        float coef5 = -coef4;
        float coef6 = sqrt5Pi / 4.0f;
        float coef7 = coef5;
        float coef8 = sqrt15Pi / 4.0f;
        shCoefs[0].multLocal(coef0).multLocal(shBandFactor[0]);
        shCoefs[1].multLocal(coef1).multLocal(shBandFactor[1]);
        shCoefs[2].multLocal(coef2).multLocal(shBandFactor[2]);
        shCoefs[3].multLocal(coef3).multLocal(shBandFactor[3]);
        shCoefs[4].multLocal(coef4).multLocal(shBandFactor[4]);
        shCoefs[5].multLocal(coef5).multLocal(shBandFactor[5]);
        shCoefs[6].multLocal(coef6).multLocal(shBandFactor[6]);
        shCoefs[7].multLocal(coef7).multLocal(shBandFactor[7]);
        shCoefs[8].multLocal(coef8).multLocal(shBandFactor[8]);
    }

    public static Vector4f getHammersleyPoint(int i, int nbrSample, Vector4f store) {
        if (store == null) {
            store = new Vector4f();
        }
        long ui = i;
        store.setX((float)i / (float)nbrSample);
        ui = ui << 16 | ui >> 16;
        ui = (ui & 0x55555555L) << 1 | (ui & 0xFFFFFFFFAAAAAAAAL) >>> 1;
        ui = (ui & 0x33333333L) << 2 | (ui & 0xFFFFFFFFCCCCCCCCL) >>> 2;
        ui = (ui & 0xF0F0F0FL) << 4 | (ui & 0xFFFFFFFFF0F0F0F0L) >>> 4;
        ui = (ui & 0xFF00FFL) << 8 | (ui & 0xFFFFFFFFFF00FF00L) >>> 8;
        store.setY(2.3283064E-10f * (float)(ui &= 0xFFFFFFFFFFFFFFFFL));
        float phi = (float)Math.PI * 2 * store.y;
        store.setZ(FastMath.cos(phi));
        store.setW(FastMath.sin(phi));
        return store;
    }

    public static Vector3f importanceSampleGGX(Vector4f xi, float a2, Vector3f normal, Vector3f store, TempVars vars) {
        if (store == null) {
            store = new Vector3f();
        }
        float cosTheta = FastMath.sqrt((1.0f - xi.x) / (1.0f + (a2 - 1.0f) * xi.x));
        float sinTheta = FastMath.sqrt(1.0f - cosTheta * cosTheta);
        float sinThetaCosPhi = sinTheta * xi.z;
        float sinThetaSinPhi = sinTheta * xi.w;
        Vector3f upVector = Vector3f.UNIT_X;
        if ((double)FastMath.abs(normal.z) < 0.999) {
            upVector = Vector3f.UNIT_Y;
        }
        Vector3f tangentX = vars.vect3.set(upVector).crossLocal(normal).normalizeLocal();
        Vector3f tangentY = vars.vect4.set(normal).crossLocal(tangentX);
        tangentX.multLocal(sinThetaCosPhi);
        tangentY.multLocal(sinThetaSinPhi);
        vars.vect5.set(normal).multLocal(cosTheta);
        store.set(tangentX).addLocal(tangentY).addLocal(vars.vect5);
        return store;
    }

    public static Node getCubeMapCrossDebugView(TextureCubeMap cubeMap, AssetManager assetManager) {
        Node n = new Node("CubeMapDebug" + cubeMap.getName());
        int size = cubeMap.getImage().getWidth();
        Picture[] pics = new Picture[6];
        float ratio = 128.0f / (float)size;
        for (int i = 0; i < 6; ++i) {
            pics[i] = new Picture("bla");
            Texture2D tex = new Texture2D(new Image(cubeMap.getImage().getFormat(), size, size, cubeMap.getImage().getData(i), cubeMap.getImage().getColorSpace()));
            pics[i].setTexture(assetManager, tex, true);
            pics[i].setWidth(size);
            pics[i].setHeight(size);
            n.attachChild(pics[i]);
        }
        pics[0].setLocalTranslation(size, size * 2, 1.0f);
        pics[0].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
        pics[1].setLocalTranslation(size * 3, size * 2, 1.0f);
        pics[1].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
        pics[2].setLocalTranslation(size * 2, size * 3, 1.0f);
        pics[2].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
        pics[3].setLocalTranslation(size * 2, size, 1.0f);
        pics[3].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
        pics[4].setLocalTranslation(size * 2, size * 2, 1.0f);
        pics[4].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
        pics[5].setLocalTranslation(size * 4, size * 2, 1.0f);
        pics[5].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
        Quad q = new Quad(size * 4, size * 3);
        Geometry g = new Geometry("bg", q);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Black);
        g.setMaterial(mat);
        g.setLocalTranslation(0.0f, 0.0f, 0.0f);
        n.attachChild(g);
        n.setLocalScale(ratio);
        return n;
    }

    public static Node getCubeMapCrossDebugViewWithMipMaps(TextureCubeMap cubeMap, AssetManager assetManager) {
        Node n = new Node("CubeMapDebug" + cubeMap.getName());
        int size = cubeMap.getImage().getWidth();
        int nbMips = cubeMap.getImage().getMipMapSizes().length;
        Picture[] pics = new Picture[6 * nbMips];
        float ratio = 1.0f;
        int offset = 0;
        int guiOffset = 0;
        for (int mipLevel = 0; mipLevel < nbMips; ++mipLevel) {
            size = Math.max(1, cubeMap.getImage().getWidth() >> mipLevel);
            int dataSize = cubeMap.getImage().getMipMapSizes()[mipLevel];
            byte[] dataArray = new byte[dataSize];
            for (int i = 0; i < 6; ++i) {
                ByteBuffer bb = cubeMap.getImage().getData(i);
                bb.rewind();
                bb.position(offset);
                bb.get(dataArray, 0, dataSize);
                ByteBuffer data = BufferUtils.createByteBuffer(dataArray);
                pics[i] = new Picture("bla");
                Texture2D tex = new Texture2D(new Image(cubeMap.getImage().getFormat(), size, size, data, cubeMap.getImage().getColorSpace()));
                pics[i].setTexture(assetManager, tex, true);
                pics[i].setWidth(size);
                pics[i].setHeight(size);
                n.attachChild(pics[i]);
            }
            pics[0].setLocalTranslation(guiOffset + size, guiOffset + size * 2, 1.0f);
            pics[0].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
            pics[1].setLocalTranslation(guiOffset + size * 3, guiOffset + size * 2, 1.0f);
            pics[1].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
            pics[2].setLocalTranslation(guiOffset + size * 2, guiOffset + size * 3, 1.0f);
            pics[2].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
            pics[3].setLocalTranslation(guiOffset + size * 2, guiOffset + size, 1.0f);
            pics[3].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
            pics[4].setLocalTranslation(guiOffset + size * 2, guiOffset + size * 2, 1.0f);
            pics[4].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
            pics[5].setLocalTranslation(guiOffset + size * 4, guiOffset + size * 2, 1.0f);
            pics[5].setLocalRotation(new Quaternion().fromAngleAxis((float)Math.PI, Vector3f.UNIT_Z));
            guiOffset += size * 2 + 1;
            offset += dataSize;
        }
        Quad q = new Quad(cubeMap.getImage().getWidth() * 4 + nbMips, guiOffset + size);
        Geometry g = new Geometry("bg", q);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Black);
        g.setMaterial(mat);
        g.setLocalTranslation(0.0f, 0.0f, 0.0f);
        n.attachChild(g);
        n.setLocalScale(ratio);
        return n;
    }

    public static TextureCubeMap createIrradianceMap(int size, Image.Format imageFormat) {
        TextureCubeMap irrMap = new TextureCubeMap(size, size, imageFormat);
        irrMap.setMagFilter(Texture.MagFilter.Bilinear);
        irrMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
        irrMap.getImage().setColorSpace(ColorSpace.Linear);
        return irrMap;
    }

    public static TextureCubeMap createPrefilteredEnvMap(int size, Image.Format imageFormat) {
        TextureCubeMap pem = new TextureCubeMap(size, size, imageFormat);
        pem.setMagFilter(Texture.MagFilter.Bilinear);
        pem.setMinFilter(Texture.MinFilter.Trilinear);
        pem.getImage().setColorSpace(ColorSpace.Linear);
        int nbMipMap = Math.min(6, (int)(Math.log(size) / Math.log(2.0)));
        CubeMapWrapper targetWrapper = new CubeMapWrapper(pem);
        targetWrapper.initMipMaps(nbMipMap);
        return pem;
    }

    public static enum FixSeamsMethod {
        Wrap,
        Stretch,
        None;

    }

    public static enum GenerationType {
        Fast,
        HighQuality;

    }
}

