/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.mikktspace;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.TangentUtils;
import com.jme3.util.mikktspace.MikkTSpaceContext;
import com.jme3.util.mikktspace.MikkTSpaceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MikktspaceTangentGenerator {
    private static final int MARK_DEGENERATE = 1;
    private static final int QUAD_ONE_DEGEN_TRI = 2;
    private static final int GROUP_WITH_ANY = 4;
    private static final int ORIENT_PRESERVING = 8;
    private static final long INTERNAL_RND_SORT_SEED = 39871946L;
    static final int CELLS = 2048;
    private static final Logger logger = Logger.getLogger(MikktspaceTangentGenerator.class.getName());

    private MikktspaceTangentGenerator() {
    }

    static int makeIndex(int face, int vert) {
        assert (vert >= 0 && vert < 4 && face >= 0);
        return face << 2 | vert & 3;
    }

    private static void indexToData(int[] face, int[] vert, int indexIn) {
        vert[0] = indexIn & 3;
        face[0] = indexIn >> 2;
    }

    static TSpace avgTSpace(TSpace tS0, TSpace tS1) {
        TSpace tsRes = new TSpace();
        if (tS0.magS == tS1.magS && tS0.magT == tS1.magT && tS0.os.equals(tS1.os) && tS0.ot.equals(tS1.ot)) {
            tsRes.magS = tS0.magS;
            tsRes.magT = tS0.magT;
            tsRes.os.set(tS0.os);
            tsRes.ot.set(tS0.ot);
        } else {
            tsRes.magS = 0.5f * (tS0.magS + tS1.magS);
            tsRes.magT = 0.5f * (tS0.magT + tS1.magT);
            tsRes.os.set(tS0.os).addLocal(tS1.os).normalizeLocal();
            tsRes.ot.set(tS0.ot).addLocal(tS1.ot).normalizeLocal();
        }
        return tsRes;
    }

    public static void generate(Spatial s) {
        if (s instanceof Node) {
            Node n = (Node)s;
            for (Spatial child : n.getChildren()) {
                MikktspaceTangentGenerator.generate(child);
            }
        } else if (s instanceof Geometry) {
            Geometry g = (Geometry)s;
            MikkTSpaceImpl context = new MikkTSpaceImpl(g.getMesh());
            if (!MikktspaceTangentGenerator.genTangSpaceDefault(context)) {
                logger.log(Level.SEVERE, "Failed to generate tangents for geometry {0}", g.getName());
            }
            TangentUtils.generateBindPoseTangentsIfNecessary(g.getMesh());
        }
    }

    public static boolean genTangSpaceDefault(MikkTSpaceContext mikkTSpace) {
        return MikktspaceTangentGenerator.genTangSpace(mikkTSpace, 180.0f);
    }

    public static boolean genTangSpace(MikkTSpaceContext mikkTSpace, float angularThreshold) {
        int t;
        int f;
        int iNrTrianglesIn = 0;
        int iNrFaces = mikkTSpace.getNumFaces();
        float fThresCos = FastMath.cos(angularThreshold * (float)Math.PI / 180.0f);
        for (f = 0; f < iNrFaces; ++f) {
            int verts = mikkTSpace.getNumVerticesOfFace(f);
            if (verts == 3) {
                ++iNrTrianglesIn;
                continue;
            }
            if (verts != 4) continue;
            iNrTrianglesIn += 2;
        }
        if (iNrTrianglesIn <= 0) {
            return false;
        }
        int[] piTriListIn = new int[3 * iNrTrianglesIn];
        TriInfo[] pTriInfos = new TriInfo[iNrTrianglesIn];
        int iNrTSPaces = MikktspaceTangentGenerator.generateInitialVerticesIndexList(pTriInfos, piTriListIn, mikkTSpace, iNrTrianglesIn);
        MikktspaceTangentGenerator.generateSharedVerticesIndexList(piTriListIn, mikkTSpace, iNrTrianglesIn);
        int iTotTris = iNrTrianglesIn;
        int iDegenTriangles = 0;
        for (t = 0; t < iTotTris; ++t) {
            int i0 = piTriListIn[t * 3 + 0];
            int i1 = piTriListIn[t * 3 + 1];
            int i2 = piTriListIn[t * 3 + 2];
            Vector3f p0 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i0);
            Vector3f p1 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i1);
            Vector3f p2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i2);
            if (!p0.equals(p1) && !p0.equals(p2) && !p1.equals(p2)) continue;
            pTriInfos[t].flag |= 1;
            ++iDegenTriangles;
        }
        iNrTrianglesIn = iTotTris - iDegenTriangles;
        MikktspaceTangentGenerator.degenPrologue(pTriInfos, piTriListIn, iNrTrianglesIn, iTotTris);
        MikktspaceTangentGenerator.initTriInfo(pTriInfos, piTriListIn, mikkTSpace, iNrTrianglesIn);
        int iNrMaxGroups = iNrTrianglesIn * 3;
        Group[] pGroups = new Group[iNrMaxGroups];
        int[] piGroupTrianglesBuffer = new int[iNrTrianglesIn * 3];
        int iNrActiveGroups = MikktspaceTangentGenerator.build4RuleGroups(pTriInfos, pGroups, piGroupTrianglesBuffer, piTriListIn, iNrTrianglesIn);
        TSpace[] psTspace = new TSpace[iNrTSPaces];
        for (t = 0; t < iNrTSPaces; ++t) {
            TSpace tSpace = new TSpace();
            tSpace.os.set(1.0f, 0.0f, 0.0f);
            tSpace.magS = 1.0f;
            tSpace.ot.set(0.0f, 1.0f, 0.0f);
            tSpace.magT = 1.0f;
            psTspace[t] = tSpace;
        }
        MikktspaceTangentGenerator.generateTSpaces(psTspace, pTriInfos, pGroups, iNrActiveGroups, piTriListIn, fThresCos, mikkTSpace);
        MikktspaceTangentGenerator.DegenEpilogue(psTspace, pTriInfos, piTriListIn, mikkTSpace, iNrTrianglesIn, iTotTris);
        int index = 0;
        for (f = 0; f < iNrFaces; ++f) {
            int verts = mikkTSpace.getNumVerticesOfFace(f);
            if (verts != 3 && verts != 4) continue;
            for (int i = 0; i < verts; ++i) {
                TSpace pTSpace = psTspace[index];
                float[] tang = new float[]{pTSpace.os.x, pTSpace.os.y, pTSpace.os.z};
                float[] bitang = new float[]{pTSpace.ot.x, pTSpace.ot.y, pTSpace.ot.z};
                mikkTSpace.setTSpace(tang, bitang, pTSpace.magS, pTSpace.magT, pTSpace.orient, f, i);
                mikkTSpace.setTSpaceBasic(tang, pTSpace.orient ? 1.0f : -1.0f, f, i);
                ++index;
            }
        }
        return true;
    }

    static int findGridCell(float min, float max, float val) {
        float fIndex = 2048.0f * ((val - min) / (max - min));
        int iIndex = (int)fIndex;
        return iIndex < 2048 ? (iIndex >= 0 ? iIndex : 0) : 2047;
    }

    static void generateSharedVerticesIndexList(int[] piTriList_in_and_out, MikkTSpaceContext mikkTSpace, int iNrTrianglesIn) {
        int k;
        int k2;
        int iCell;
        float fVal;
        Vector3f vP;
        int index;
        int i;
        Vector3f vMin = MikktspaceTangentGenerator.getPosition(mikkTSpace, 0);
        Vector3f vMax = vMin.clone();
        for (int i2 = 1; i2 < iNrTrianglesIn * 3; ++i2) {
            int index2 = piTriList_in_and_out[i2];
            Vector3f vP2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, index2);
            if (vMin.x > vP2.x) {
                vMin.x = vP2.x;
            } else if (vMax.x < vP2.x) {
                vMax.x = vP2.x;
            }
            if (vMin.y > vP2.y) {
                vMin.y = vP2.y;
            } else if (vMax.y < vP2.y) {
                vMax.y = vP2.y;
            }
            if (vMin.z > vP2.z) {
                vMin.z = vP2.z;
                continue;
            }
            if (!(vMax.z < vP2.z)) continue;
            vMax.z = vP2.z;
        }
        Vector3f vDim = vMax.subtract(vMin);
        int iChannel = 0;
        float fMin = vMin.x;
        float fMax = vMax.x;
        if (vDim.y > vDim.x && vDim.y > vDim.z) {
            iChannel = 1;
            fMin = vMin.y;
            fMax = vMax.y;
        } else if (vDim.z > vDim.x) {
            iChannel = 2;
            fMin = vMin.z;
            fMax = vMax.z;
        }
        int[] piHashTable = new int[iNrTrianglesIn * 3];
        int[] piHashCount = new int[2048];
        int[] piHashOffsets = new int[2048];
        int[] piHashCount2 = new int[2048];
        for (i = 0; i < iNrTrianglesIn * 3; ++i) {
            index = piTriList_in_and_out[i];
            vP = MikktspaceTangentGenerator.getPosition(mikkTSpace, index);
            fVal = iChannel == 0 ? vP.x : (iChannel == 1 ? vP.y : vP.z);
            int n = iCell = MikktspaceTangentGenerator.findGridCell(fMin, fMax, fVal);
            piHashCount[n] = piHashCount[n] + 1;
        }
        piHashOffsets[0] = 0;
        for (k2 = 1; k2 < 2048; ++k2) {
            piHashOffsets[k2] = piHashOffsets[k2 - 1] + piHashCount[k2 - 1];
        }
        i = 0;
        while (i < iNrTrianglesIn * 3) {
            index = piTriList_in_and_out[i];
            vP = MikktspaceTangentGenerator.getPosition(mikkTSpace, index);
            fVal = iChannel == 0 ? vP.x : (iChannel == 1 ? vP.y : vP.z);
            iCell = MikktspaceTangentGenerator.findGridCell(fMin, fMax, fVal);
            assert (piHashCount2[iCell] < piHashCount[iCell]);
            piHashTable[piHashOffsets[iCell] + piHashCount2[iCell]] = i++;
            int n = iCell;
            piHashCount2[n] = piHashCount2[n] + 1;
        }
        for (k2 = 0; k2 < 2048; ++k2) {
            assert (piHashCount2[k2] == piHashCount[k2]);
        }
        int iMaxCount = piHashCount[0];
        for (k = 1; k < 2048; ++k) {
            if (iMaxCount >= piHashCount[k]) continue;
            iMaxCount = piHashCount[k];
        }
        TmpVert[] pTmpVert = new TmpVert[iMaxCount];
        for (k = 0; k < 2048; ++k) {
            int iEntries = piHashCount[k];
            if (iEntries < 2) continue;
            if (pTmpVert != null) {
                for (int e = 0; e < iEntries; ++e) {
                    int j = piHashTable[piHashOffsets[k] + e];
                    Vector3f vP3 = MikktspaceTangentGenerator.getPosition(mikkTSpace, piTriList_in_and_out[j]);
                    pTmpVert[e] = new TmpVert();
                    pTmpVert[e].vert[0] = vP3.x;
                    pTmpVert[e].vert[1] = vP3.y;
                    pTmpVert[e].vert[2] = vP3.z;
                    pTmpVert[e].index = j;
                }
                MikktspaceTangentGenerator.MergeVertsFast(piTriList_in_and_out, pTmpVert, mikkTSpace, 0, iEntries - 1);
                continue;
            }
            int[] pTable = Arrays.copyOfRange(piHashTable, piHashOffsets[k], piHashOffsets[k] + iEntries);
            MikktspaceTangentGenerator.MergeVertsSlow(piTriList_in_and_out, mikkTSpace, pTable, iEntries);
        }
    }

    static void MergeVertsFast(int[] piTriList_in_and_out, TmpVert[] pTmpVert, MikkTSpaceContext mikkTSpace, int iL_in, int iR_in) {
        float[] fvMin = new float[3];
        float[] fvMax = new float[3];
        for (int c = 0; c < 3; ++c) {
            fvMin[c] = pTmpVert[iL_in].vert[c];
            fvMax[c] = fvMin[c];
        }
        for (int l = iL_in + 1; l <= iR_in; ++l) {
            for (int c = 0; c < 3; ++c) {
                if (fvMin[c] > pTmpVert[l].vert[c]) {
                    fvMin[c] = pTmpVert[l].vert[c];
                    continue;
                }
                if (!(fvMax[c] < pTmpVert[l].vert[c])) continue;
                fvMax[c] = pTmpVert[l].vert[c];
            }
        }
        float dx = fvMax[0] - fvMin[0];
        float dy = fvMax[1] - fvMin[1];
        float dz = fvMax[2] - fvMin[2];
        int channel = 0;
        if (dy > dx && dy > dz) {
            channel = 1;
        } else if (dz > dx) {
            channel = 2;
        }
        float fSep = 0.5f * (fvMax[channel] + fvMin[channel]);
        if (fSep >= fvMax[channel] || fSep <= fvMin[channel]) {
            for (int l = iL_in; l <= iR_in; ++l) {
                int i = pTmpVert[l].index;
                int index = piTriList_in_and_out[i];
                Vector3f vP = MikktspaceTangentGenerator.getPosition(mikkTSpace, index);
                Vector3f vN = MikktspaceTangentGenerator.getNormal(mikkTSpace, index);
                Vector3f vT = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, index);
                boolean bNotFound = true;
                int l2 = iL_in;
                int i2rec = -1;
                while (l2 < l && bNotFound) {
                    int i2 = pTmpVert[l2].index;
                    int index2 = piTriList_in_and_out[i2];
                    Vector3f vP2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, index2);
                    Vector3f vN2 = MikktspaceTangentGenerator.getNormal(mikkTSpace, index2);
                    Vector3f vT2 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, index2);
                    i2rec = i2;
                    if (vP.x == vP2.x && vP.y == vP2.y && vP.z == vP2.z && vN.x == vN2.x && vN.y == vN2.y && vN.z == vN2.z && vT.x == vT2.x && vT.y == vT2.y && vT.z == vT2.z) {
                        bNotFound = false;
                        continue;
                    }
                    ++l2;
                }
                if (bNotFound) continue;
                piTriList_in_and_out[i] = piTriList_in_and_out[i2rec];
            }
        } else {
            int iL = iL_in;
            int iR = iR_in;
            assert (iR_in - iL_in > 0);
            while (iL < iR) {
                boolean bReadyLeftSwap = false;
                boolean bReadyRightSwap = false;
                while (!bReadyLeftSwap && iL < iR) {
                    assert (iL >= iL_in && iL <= iR_in);
                    bReadyLeftSwap = pTmpVert[iL].vert[channel] >= fSep;
                    if (bReadyLeftSwap) continue;
                    ++iL;
                }
                while (!bReadyRightSwap && iL < iR) {
                    assert (iR >= iL_in && iR <= iR_in);
                    bReadyRightSwap = pTmpVert[iR].vert[channel] < fSep;
                    if (bReadyRightSwap) continue;
                    --iR;
                }
                assert (iL < iR || !bReadyLeftSwap || !bReadyRightSwap);
                if (!bReadyLeftSwap || !bReadyRightSwap) continue;
                TmpVert sTmp = pTmpVert[iL];
                assert (iL < iR);
                pTmpVert[iL] = pTmpVert[iR];
                pTmpVert[iR] = sTmp;
                ++iL;
                --iR;
            }
            assert (iL == iR + 1 || iL == iR);
            if (iL == iR) {
                boolean bReadyRightSwap;
                boolean bl = bReadyRightSwap = pTmpVert[iR].vert[channel] < fSep;
                if (bReadyRightSwap) {
                    ++iL;
                } else {
                    --iR;
                }
            }
            if (iL_in < iR) {
                MikktspaceTangentGenerator.MergeVertsFast(piTriList_in_and_out, pTmpVert, mikkTSpace, iL_in, iR);
            }
            if (iL < iR_in) {
                MikktspaceTangentGenerator.MergeVertsFast(piTriList_in_and_out, pTmpVert, mikkTSpace, iL, iR_in);
            }
        }
    }

    static void MergeVertsSlow(int[] piTriList_in_and_out, MikkTSpaceContext mikkTSpace, int[] pTable, int iEntries) {
        for (int e = 0; e < iEntries; ++e) {
            int i = pTable[e];
            int index = piTriList_in_and_out[i];
            Vector3f vP = MikktspaceTangentGenerator.getPosition(mikkTSpace, index);
            Vector3f vN = MikktspaceTangentGenerator.getNormal(mikkTSpace, index);
            Vector3f vT = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, index);
            boolean bNotFound = true;
            int e2 = 0;
            int i2rec = -1;
            while (e2 < e && bNotFound) {
                int i2 = pTable[e2];
                int index2 = piTriList_in_and_out[i2];
                Vector3f vP2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, index2);
                Vector3f vN2 = MikktspaceTangentGenerator.getNormal(mikkTSpace, index2);
                Vector3f vT2 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, index2);
                i2rec = i2;
                if (vP.equals(vP2) && vN.equals(vN2) && vT.equals(vT2)) {
                    bNotFound = false;
                    continue;
                }
                ++e2;
            }
            if (bNotFound) continue;
            piTriList_in_and_out[i] = piTriList_in_and_out[i2rec];
        }
    }

    static void generateSharedVerticesIndexListSlow(int[] piTriList_in_and_out, MikkTSpaceContext mikkTSpace, int iNrTrianglesIn) {
        int iNumUniqueVerts = 0;
        for (int t = 0; t < iNrTrianglesIn; ++t) {
            for (int i = 0; i < 3; ++i) {
                int offs = t * 3 + i;
                int index = piTriList_in_and_out[offs];
                Vector3f vP = MikktspaceTangentGenerator.getPosition(mikkTSpace, index);
                Vector3f vN = MikktspaceTangentGenerator.getNormal(mikkTSpace, index);
                Vector3f vT = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, index);
                boolean bFound = false;
                int t2 = 0;
                int index2rec = -1;
                while (!bFound && t2 <= t) {
                    int j = 0;
                    while (!bFound && j < 3) {
                        int index2 = piTriList_in_and_out[t2 * 3 + j];
                        Vector3f vP2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, index2);
                        Vector3f vN2 = MikktspaceTangentGenerator.getNormal(mikkTSpace, index2);
                        Vector3f vT2 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, index2);
                        if (vP.equals(vP2) && vN.equals(vN2) && vT.equals(vT2)) {
                            bFound = true;
                            continue;
                        }
                        ++j;
                    }
                    if (bFound) continue;
                    ++t2;
                }
                assert (bFound);
                if (index2rec == index) {
                    ++iNumUniqueVerts;
                }
                piTriList_in_and_out[offs] = index2rec;
            }
        }
    }

    static int generateInitialVerticesIndexList(TriInfo[] pTriInfos, int[] piTriList_out, MikkTSpaceContext mikkTSpace, int iNrTrianglesIn) {
        int iTSpacesOffs = 0;
        int iDstTriIndex = 0;
        for (int f = 0; f < mikkTSpace.getNumFaces(); ++f) {
            int verts = mikkTSpace.getNumVerticesOfFace(f);
            if (verts != 3 && verts != 4) continue;
            pTriInfos[iDstTriIndex] = new TriInfo();
            pTriInfos[iDstTriIndex].orgFaceNumber = f;
            pTriInfos[iDstTriIndex].tSpacesOffs = iTSpacesOffs;
            if (verts == 3) {
                byte[] pVerts = pTriInfos[iDstTriIndex].vertNum;
                pVerts[0] = 0;
                pVerts[1] = 1;
                pVerts[2] = 2;
                piTriList_out[iDstTriIndex * 3 + 0] = MikktspaceTangentGenerator.makeIndex(f, 0);
                piTriList_out[iDstTriIndex * 3 + 1] = MikktspaceTangentGenerator.makeIndex(f, 1);
                piTriList_out[iDstTriIndex * 3 + 2] = MikktspaceTangentGenerator.makeIndex(f, 2);
                ++iDstTriIndex;
            } else {
                byte[] pVerts_B;
                byte[] pVerts_A;
                boolean bQuadDiagIs_02;
                float distSQ_13;
                pTriInfos[iDstTriIndex + 1].orgFaceNumber = f;
                pTriInfos[iDstTriIndex + 1].tSpacesOffs = iTSpacesOffs;
                int i0 = MikktspaceTangentGenerator.makeIndex(f, 0);
                int i1 = MikktspaceTangentGenerator.makeIndex(f, 1);
                int i2 = MikktspaceTangentGenerator.makeIndex(f, 2);
                int i3 = MikktspaceTangentGenerator.makeIndex(f, 3);
                Vector3f T0 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, i0);
                Vector3f T1 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, i1);
                Vector3f T2 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, i2);
                Vector3f T3 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, i3);
                float distSQ_02 = T2.subtract(T0).lengthSquared();
                if (distSQ_02 < (distSQ_13 = T3.subtract(T1).lengthSquared())) {
                    bQuadDiagIs_02 = true;
                } else if (distSQ_13 < distSQ_02) {
                    bQuadDiagIs_02 = false;
                } else {
                    Vector3f P0 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i0);
                    Vector3f P1 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i1);
                    Vector3f P2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i2);
                    Vector3f P3 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i3);
                    float distSQ_022 = P2.subtract(P0).lengthSquared();
                    float distSQ_132 = P3.subtract(P1).lengthSquared();
                    boolean bl = bQuadDiagIs_02 = distSQ_132 >= distSQ_022;
                }
                if (bQuadDiagIs_02) {
                    pVerts_A = pTriInfos[iDstTriIndex].vertNum;
                    pVerts_A[0] = 0;
                    pVerts_A[1] = 1;
                    pVerts_A[2] = 2;
                    piTriList_out[iDstTriIndex * 3 + 0] = i0;
                    piTriList_out[iDstTriIndex * 3 + 1] = i1;
                    piTriList_out[iDstTriIndex * 3 + 2] = i2;
                    pVerts_B = pTriInfos[++iDstTriIndex].vertNum;
                    pVerts_B[0] = 0;
                    pVerts_B[1] = 2;
                    pVerts_B[2] = 3;
                    piTriList_out[iDstTriIndex * 3 + 0] = i0;
                    piTriList_out[iDstTriIndex * 3 + 1] = i2;
                    piTriList_out[iDstTriIndex * 3 + 2] = i3;
                    ++iDstTriIndex;
                } else {
                    pVerts_A = pTriInfos[iDstTriIndex].vertNum;
                    pVerts_A[0] = 0;
                    pVerts_A[1] = 1;
                    pVerts_A[2] = 3;
                    piTriList_out[iDstTriIndex * 3 + 0] = i0;
                    piTriList_out[iDstTriIndex * 3 + 1] = i1;
                    piTriList_out[iDstTriIndex * 3 + 2] = i3;
                    pVerts_B = pTriInfos[++iDstTriIndex].vertNum;
                    pVerts_B[0] = 1;
                    pVerts_B[1] = 2;
                    pVerts_B[2] = 3;
                    piTriList_out[iDstTriIndex * 3 + 0] = i1;
                    piTriList_out[iDstTriIndex * 3 + 1] = i2;
                    piTriList_out[iDstTriIndex * 3 + 2] = i3;
                    ++iDstTriIndex;
                }
            }
            iTSpacesOffs += verts;
            assert (iDstTriIndex <= iNrTrianglesIn);
        }
        for (int t = 0; t < iNrTrianglesIn; ++t) {
            pTriInfos[t].flag = 0;
        }
        return iTSpacesOffs;
    }

    static Vector3f getPosition(MikkTSpaceContext mikkTSpace, int index) {
        int[] iF = new int[1];
        int[] iI = new int[1];
        float[] pos = new float[3];
        MikktspaceTangentGenerator.indexToData(iF, iI, index);
        mikkTSpace.getPosition(pos, iF[0], iI[0]);
        return new Vector3f(pos[0], pos[1], pos[2]);
    }

    static Vector3f getNormal(MikkTSpaceContext mikkTSpace, int index) {
        int[] iF = new int[1];
        int[] iI = new int[1];
        float[] norm = new float[3];
        MikktspaceTangentGenerator.indexToData(iF, iI, index);
        mikkTSpace.getNormal(norm, iF[0], iI[0]);
        return new Vector3f(norm[0], norm[1], norm[2]);
    }

    static Vector3f getTexCoord(MikkTSpaceContext mikkTSpace, int index) {
        int[] iF = new int[1];
        int[] iI = new int[1];
        float[] texc = new float[2];
        MikktspaceTangentGenerator.indexToData(iF, iI, index);
        mikkTSpace.getTexCoord(texc, iF[0], iI[0]);
        return new Vector3f(texc[0], texc[1], 1.0f);
    }

    static float calcTexArea(MikkTSpaceContext mikkTSpace, int[] indices) {
        Vector3f t1 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, indices[0]);
        Vector3f t2 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, indices[1]);
        Vector3f t3 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, indices[2]);
        float t21x = t2.x - t1.x;
        float t31y = t3.y - t1.y;
        float t21y = t2.y - t1.y;
        float t31x = t3.x - t1.x;
        float fSignedAreaSTx2 = t21x * t31y - t21y * t31x;
        return fSignedAreaSTx2 < 0.0f ? -fSignedAreaSTx2 : fSignedAreaSTx2;
    }

    private static boolean isNotZero(float v) {
        return Math.abs(v) > 0.0f;
    }

    static void initTriInfo(TriInfo[] pTriInfos, int[] piTriListIn, MikkTSpaceContext mikkTSpace, int iNrTrianglesIn) {
        int f;
        for (f = 0; f < iNrTrianglesIn; ++f) {
            for (int i = 0; i < 3; ++i) {
                pTriInfos[f].faceNeighbors[i] = -1;
                pTriInfos[f].assignedGroup[i] = null;
                pTriInfos[f].os.x = 0.0f;
                pTriInfos[f].os.y = 0.0f;
                pTriInfos[f].os.z = 0.0f;
                pTriInfos[f].ot.x = 0.0f;
                pTriInfos[f].ot.y = 0.0f;
                pTriInfos[f].ot.z = 0.0f;
                pTriInfos[f].magS = 0.0f;
                pTriInfos[f].magT = 0.0f;
                pTriInfos[f].flag |= 4;
            }
        }
        for (f = 0; f < iNrTrianglesIn; ++f) {
            float fS;
            Vector3f v1 = MikktspaceTangentGenerator.getPosition(mikkTSpace, piTriListIn[f * 3 + 0]);
            Vector3f v2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, piTriListIn[f * 3 + 1]);
            Vector3f v3 = MikktspaceTangentGenerator.getPosition(mikkTSpace, piTriListIn[f * 3 + 2]);
            Vector3f t1 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, piTriListIn[f * 3 + 0]);
            Vector3f t2 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, piTriListIn[f * 3 + 1]);
            Vector3f t3 = MikktspaceTangentGenerator.getTexCoord(mikkTSpace, piTriListIn[f * 3 + 2]);
            float t21x = t2.x - t1.x;
            float t21y = t2.y - t1.y;
            float t31x = t3.x - t1.x;
            float t31y = t3.y - t1.y;
            Vector3f d1 = v2.subtract(v1);
            Vector3f d2 = v3.subtract(v1);
            float fSignedAreaSTx2 = t21x * t31y - t21y * t31x;
            Vector3f vOs = d1.mult(t31y).subtract(d2.mult(t21y));
            Vector3f vOt = d1.mult(-t31x).add(d2.mult(t21x));
            pTriInfos[f].flag = pTriInfos[f].flag | (fSignedAreaSTx2 > 0.0f ? 8 : 0);
            if (!MikktspaceTangentGenerator.isNotZero(fSignedAreaSTx2)) continue;
            float fAbsArea = Math.abs(fSignedAreaSTx2);
            float fLenOs = vOs.length();
            float fLenOt = vOt.length();
            float f2 = fS = (pTriInfos[f].flag & 8) == 0 ? -1.0f : 1.0f;
            if (MikktspaceTangentGenerator.isNotZero(fLenOs)) {
                pTriInfos[f].os = vOs.multLocal(fS / fLenOs);
            }
            if (MikktspaceTangentGenerator.isNotZero(fLenOt)) {
                pTriInfos[f].ot = vOt.multLocal(fS / fLenOt);
            }
            pTriInfos[f].magS = fLenOs / fAbsArea;
            pTriInfos[f].magT = fLenOt / fAbsArea;
            if (!MikktspaceTangentGenerator.isNotZero(pTriInfos[f].magS) || !MikktspaceTangentGenerator.isNotZero(pTriInfos[f].magT)) continue;
            pTriInfos[f].flag &= 0xFFFFFFFB;
        }
        int t = 0;
        while (t < iNrTrianglesIn - 1) {
            int iFO_a = pTriInfos[t].orgFaceNumber;
            int iFO_b = pTriInfos[t + 1].orgFaceNumber;
            if (iFO_a == iFO_b) {
                boolean bIsDeg_a = (pTriInfos[t].flag & 1) != 0;
                boolean bIsDeg_b = (pTriInfos[t + 1].flag & 1) != 0;
                if (!(bIsDeg_a || bIsDeg_b)) {
                    boolean bOrientB;
                    boolean bOrientA = (pTriInfos[t].flag & 8) != 0;
                    boolean bl = bOrientB = (pTriInfos[t + 1].flag & 8) != 0;
                    if (bOrientA != bOrientB) {
                        boolean bChooseOrientFirstTri = false;
                        if ((pTriInfos[t + 1].flag & 4) != 0) {
                            bChooseOrientFirstTri = true;
                        } else if (MikktspaceTangentGenerator.calcTexArea(mikkTSpace, Arrays.copyOfRange(piTriListIn, t * 3 + 0, t * 3 + 3)) >= MikktspaceTangentGenerator.calcTexArea(mikkTSpace, Arrays.copyOfRange(piTriListIn, (t + 1) * 3 + 0, (t + 1) * 3 + 3))) {
                            bChooseOrientFirstTri = true;
                        }
                        int t0 = bChooseOrientFirstTri ? t : t + 1;
                        int t1 = bChooseOrientFirstTri ? t + 1 : t;
                        pTriInfos[t1].flag &= 0xFFFFFFF7;
                        pTriInfos[t1].flag |= pTriInfos[t0].flag & 8;
                    }
                }
                t += 2;
                continue;
            }
            ++t;
        }
        Edge[] pEdges = new Edge[iNrTrianglesIn * 3];
        MikktspaceTangentGenerator.buildNeighborsFast(pTriInfos, pEdges, piTriListIn, iNrTrianglesIn);
    }

    static int build4RuleGroups(TriInfo[] pTriInfos, Group[] pGroups, int[] piGroupTrianglesBuffer, int[] piTriListIn, int iNrTrianglesIn) {
        int iNrMaxGroups = iNrTrianglesIn * 3;
        int iNrActiveGroups = 0;
        int iOffset = 0;
        for (int f = 0; f < iNrTrianglesIn; ++f) {
            for (int i = 0; i < 3; ++i) {
                boolean bDiff;
                boolean bOrPre2;
                boolean bAnswer;
                if ((pTriInfos[f].flag & 4) != 0 || pTriInfos[f].assignedGroup[i] != null) continue;
                int vert_index = piTriListIn[f * 3 + i];
                assert (iNrActiveGroups < iNrMaxGroups);
                pTriInfos[f].assignedGroup[i] = new Group();
                pGroups[iNrActiveGroups] = pTriInfos[f].assignedGroup[i];
                pTriInfos[f].assignedGroup[i].vertexRepresentative = vert_index;
                pTriInfos[f].assignedGroup[i].orientationPreserving = (pTriInfos[f].flag & 8) != 0;
                pTriInfos[f].assignedGroup[i].nrFaces = 0;
                ++iNrActiveGroups;
                MikktspaceTangentGenerator.addTriToGroup(pTriInfos[f].assignedGroup[i], f);
                boolean bOrPre = (pTriInfos[f].flag & 8) != 0;
                int neigh_indexL = pTriInfos[f].faceNeighbors[i];
                int neigh_indexR = pTriInfos[f].faceNeighbors[i > 0 ? i - 1 : 2];
                if (neigh_indexL >= 0) {
                    bAnswer = MikktspaceTangentGenerator.assignRecur(piTriListIn, pTriInfos, neigh_indexL, pTriInfos[f].assignedGroup[i]);
                    bOrPre2 = (pTriInfos[neigh_indexL].flag & 8) != 0;
                    boolean bl = bDiff = bOrPre != bOrPre2;
                    assert (bAnswer || bDiff);
                }
                if (neigh_indexR >= 0) {
                    bAnswer = MikktspaceTangentGenerator.assignRecur(piTriListIn, pTriInfos, neigh_indexR, pTriInfos[f].assignedGroup[i]);
                    bOrPre2 = (pTriInfos[neigh_indexR].flag & 8) != 0;
                    boolean bl = bDiff = bOrPre != bOrPre2;
                    assert (bAnswer || bDiff);
                }
                int[] faceIndices = new int[pTriInfos[f].assignedGroup[i].nrFaces];
                for (int j = 0; j < faceIndices.length; ++j) {
                    faceIndices[j] = pTriInfos[f].assignedGroup[i].faceIndices.get(j);
                }
                System.arraycopy(faceIndices, 0, piGroupTrianglesBuffer, iOffset, pTriInfos[f].assignedGroup[i].nrFaces);
                assert ((iOffset += pTriInfos[f].assignedGroup[i].nrFaces) <= iNrMaxGroups);
            }
        }
        return iNrActiveGroups;
    }

    static void addTriToGroup(Group group, int triIndex) {
        group.faceIndices.add(triIndex);
        ++group.nrFaces;
    }

    static boolean assignRecur(int[] piTriListIn, TriInfo[] psTriInfos, int iMyTriIndex, Group pGroup) {
        boolean bOrient;
        TriInfo pMyTriInfo = psTriInfos[iMyTriIndex];
        int iVertRep = pGroup.vertexRepresentative;
        int index = 3 * iMyTriIndex;
        int i = -1;
        if (piTriListIn[index] == iVertRep) {
            i = 0;
        } else if (piTriListIn[index + 1] == iVertRep) {
            i = 1;
        } else if (piTriListIn[index + 2] == iVertRep) {
            i = 2;
        }
        assert (i >= 0 && i < 3);
        if (pMyTriInfo.assignedGroup[i] == pGroup) {
            return true;
        }
        if (pMyTriInfo.assignedGroup[i] != null) {
            return false;
        }
        if ((pMyTriInfo.flag & 4) != 0 && pMyTriInfo.assignedGroup[0] == null && pMyTriInfo.assignedGroup[1] == null && pMyTriInfo.assignedGroup[2] == null) {
            pMyTriInfo.flag &= 0xFFFFFFF7;
            pMyTriInfo.flag = pMyTriInfo.flag | (pGroup.orientationPreserving ? 8 : 0);
        }
        boolean bl = bOrient = (pMyTriInfo.flag & 8) != 0;
        if (bOrient != pGroup.orientationPreserving) {
            return false;
        }
        MikktspaceTangentGenerator.addTriToGroup(pGroup, iMyTriIndex);
        pMyTriInfo.assignedGroup[i] = pGroup;
        int neigh_indexL = pMyTriInfo.faceNeighbors[i];
        int neigh_indexR = pMyTriInfo.faceNeighbors[i > 0 ? i - 1 : 2];
        if (neigh_indexL >= 0) {
            MikktspaceTangentGenerator.assignRecur(piTriListIn, psTriInfos, neigh_indexL, pGroup);
        }
        if (neigh_indexR >= 0) {
            MikktspaceTangentGenerator.assignRecur(piTriListIn, psTriInfos, neigh_indexR, pGroup);
        }
        return true;
    }

    static boolean generateTSpaces(TSpace[] psTspace, TriInfo[] pTriInfos, Group[] pGroups, int iNrActiveGroups, int[] piTriListIn, float fThresCos, MikkTSpaceContext mikkTSpace) {
        int iMaxNrFaces = 0;
        int iUniqueTspaces = 0;
        int g = 0;
        int i = 0;
        for (g = 0; g < iNrActiveGroups; ++g) {
            if (iMaxNrFaces >= pGroups[g].nrFaces) continue;
            iMaxNrFaces = pGroups[g].nrFaces;
        }
        if (iMaxNrFaces == 0) {
            return true;
        }
        TSpace[] pSubGroupTspace = new TSpace[iMaxNrFaces];
        SubGroup[] pUniSubGroups = new SubGroup[iMaxNrFaces];
        int[] pTmpMembers = new int[iMaxNrFaces];
        iUniqueTspaces = 0;
        for (g = 0; g < iNrActiveGroups; ++g) {
            Group pGroup = pGroups[g];
            int iUniqueSubGroups = 0;
            boolean s = false;
            for (i = 0; i < pGroup.nrFaces; ++i) {
                int f = pGroup.faceIndices.get(i);
                int index = -1;
                int iVertIndex = -1;
                int iOF_1 = -1;
                int iMembers = 0;
                int j = 0;
                int l = 0;
                SubGroup tmp_group = new SubGroup();
                if (pTriInfos[f].assignedGroup[0] == pGroup) {
                    index = 0;
                } else if (pTriInfos[f].assignedGroup[1] == pGroup) {
                    index = 1;
                } else if (pTriInfos[f].assignedGroup[2] == pGroup) {
                    index = 2;
                }
                assert (index >= 0 && index < 3);
                iVertIndex = piTriListIn[f * 3 + index];
                assert (iVertIndex == pGroup.vertexRepresentative);
                Vector3f n = MikktspaceTangentGenerator.getNormal(mikkTSpace, iVertIndex);
                Vector3f vOs = pTriInfos[f].os.subtract(n.mult(n.dot(pTriInfos[f].os)));
                Vector3f vOt = pTriInfos[f].ot.subtract(n.mult(n.dot(pTriInfos[f].ot)));
                vOs.normalizeLocal();
                vOt.normalizeLocal();
                iOF_1 = pTriInfos[f].orgFaceNumber;
                iMembers = 0;
                for (j = 0; j < pGroup.nrFaces; ++j) {
                    int t = pGroup.faceIndices.get(j);
                    int iOF_2 = pTriInfos[t].orgFaceNumber;
                    Vector3f vOs2 = pTriInfos[t].os.subtract(n.mult(n.dot(pTriInfos[t].os)));
                    Vector3f vOt2 = pTriInfos[t].ot.subtract(n.mult(n.dot(pTriInfos[t].ot)));
                    vOs2.normalizeLocal();
                    vOt2.normalizeLocal();
                    boolean bAny = ((pTriInfos[f].flag | pTriInfos[t].flag) & 4) != 0;
                    boolean bSameOrgFace = iOF_1 == iOF_2;
                    float fCosS = vOs.dot(vOs2);
                    float fCosT = vOt.dot(vOt2);
                    assert (f != t || bSameOrgFace);
                    if (!bAny && !bSameOrgFace && (!(fCosS > fThresCos) || !(fCosT > fThresCos))) continue;
                    pTmpMembers[iMembers++] = t;
                }
                tmp_group.nrFaces = iMembers;
                tmp_group.triMembers = pTmpMembers;
                if (iMembers > 1) {
                    MikktspaceTangentGenerator.quickSort(pTmpMembers, 0, iMembers - 1, 39871946L);
                }
                boolean bFound = false;
                l = 0;
                while (l < iUniqueSubGroups && !bFound) {
                    bFound = MikktspaceTangentGenerator.compareSubGroups(tmp_group, pUniSubGroups[l]);
                    if (bFound) continue;
                    ++l;
                }
                assert (bFound || l == iUniqueSubGroups);
                if (!bFound) {
                    int[] pIndices = new int[iMembers];
                    pUniSubGroups[iUniqueSubGroups] = new SubGroup();
                    pUniSubGroups[iUniqueSubGroups].nrFaces = iMembers;
                    pUniSubGroups[iUniqueSubGroups].triMembers = pIndices;
                    System.arraycopy(tmp_group.triMembers, 0, pIndices, 0, iMembers);
                    pSubGroupTspace[iUniqueSubGroups] = MikktspaceTangentGenerator.evalTspace(tmp_group.triMembers, iMembers, piTriListIn, pTriInfos, mikkTSpace, pGroup.vertexRepresentative);
                    ++iUniqueSubGroups;
                }
                int iOffs = pTriInfos[f].tSpacesOffs;
                byte iVert = pTriInfos[f].vertNum[index];
                TSpace pTS_out = psTspace[iOffs + iVert];
                assert (pTS_out.counter < 2);
                assert ((pTriInfos[f].flag & 8) != 0 == pGroup.orientationPreserving);
                if (pTS_out.counter == 1) {
                    pTS_out.set(MikktspaceTangentGenerator.avgTSpace(pTS_out, pSubGroupTspace[l]));
                    pTS_out.counter = 2;
                    pTS_out.orient = pGroup.orientationPreserving;
                    continue;
                }
                assert (pTS_out.counter == 0);
                pTS_out.set(pSubGroupTspace[l]);
                pTS_out.counter = 1;
                pTS_out.orient = pGroup.orientationPreserving;
            }
            iUniqueTspaces += iUniqueSubGroups;
        }
        return true;
    }

    static TSpace evalTspace(int[] face_indices, int iFaces, int[] piTriListIn, TriInfo[] pTriInfos, MikkTSpaceContext mikkTSpace, int iVertexRepresentitive) {
        TSpace res = new TSpace();
        float fAngleSum = 0.0f;
        for (int face = 0; face < iFaces; ++face) {
            int f = face_indices[face];
            if ((pTriInfos[f].flag & 4) != 0) continue;
            int i = -1;
            if (piTriListIn[3 * f + 0] == iVertexRepresentitive) {
                i = 0;
            } else if (piTriListIn[3 * f + 1] == iVertexRepresentitive) {
                i = 1;
            } else if (piTriListIn[3 * f + 2] == iVertexRepresentitive) {
                i = 2;
            }
            assert (i >= 0 && i < 3);
            int index = piTriListIn[3 * f + i];
            Vector3f n = MikktspaceTangentGenerator.getNormal(mikkTSpace, index);
            Vector3f vOs = pTriInfos[f].os.subtract(n.mult(n.dot(pTriInfos[f].os)));
            Vector3f vOt = pTriInfos[f].ot.subtract(n.mult(n.dot(pTriInfos[f].ot)));
            vOs.normalizeLocal();
            vOt.normalizeLocal();
            int i2 = piTriListIn[3 * f + (i < 2 ? i + 1 : 0)];
            int i1 = piTriListIn[3 * f + i];
            int i0 = piTriListIn[3 * f + (i > 0 ? i - 1 : 2)];
            Vector3f p0 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i0);
            Vector3f p1 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i1);
            Vector3f p2 = MikktspaceTangentGenerator.getPosition(mikkTSpace, i2);
            Vector3f v1 = p0.subtract(p1);
            Vector3f v2 = p2.subtract(p1);
            v1.subtractLocal(n.mult(n.dot(v1))).normalizeLocal();
            v2.subtractLocal(n.mult(n.dot(v2))).normalizeLocal();
            float fCos = v1.dot(v2);
            fCos = fCos > 1.0f ? 1.0f : (fCos < -1.0f ? -1.0f : fCos);
            float fAngle = (float)Math.acos(fCos);
            float fMagS = pTriInfos[f].magS;
            float fMagT = pTriInfos[f].magT;
            res.os.addLocal(vOs.multLocal(fAngle));
            res.ot.addLocal(vOt.multLocal(fAngle));
            res.magS += fAngle * fMagS;
            res.magT += fAngle * fMagT;
            fAngleSum += fAngle;
        }
        res.os.normalizeLocal();
        res.ot.normalizeLocal();
        if (fAngleSum > 0.0f) {
            res.magS /= fAngleSum;
            res.magT /= fAngleSum;
        }
        return res;
    }

    static boolean compareSubGroups(SubGroup pg1, SubGroup pg2) {
        if (pg2 == null || pg1.nrFaces != pg2.nrFaces) {
            return false;
        }
        boolean stillSame = true;
        int i = 0;
        while (i < pg1.nrFaces && stillSame) {
            stillSame = pg1.triMembers[i] == pg2.triMembers[i];
            if (!stillSame) continue;
            ++i;
        }
        return stillSame;
    }

    static void quickSort(int[] pSortBuffer, int iLeft, int iRight, long uSeed) {
        long t = uSeed & 0x1FL;
        t = uSeed << (int)t | uSeed >> (int)(32L - t);
        uSeed = uSeed + t + 3L;
        uSeed &= 0xFFFFFFFFL;
        int iL = iLeft;
        int iR = iRight;
        int n = iR - iL + 1;
        assert (n >= 0);
        int index = (int)((uSeed & 0xFFFFFFFFL) % (long)n);
        int iMid = pSortBuffer[index + iL];
        while (true) {
            if (pSortBuffer[iL] < iMid) {
                ++iL;
                continue;
            }
            while (pSortBuffer[iR] > iMid) {
                --iR;
            }
            if (iL <= iR) {
                int iTmp = pSortBuffer[iL];
                pSortBuffer[iL] = pSortBuffer[iR];
                pSortBuffer[iR] = iTmp;
                ++iL;
                --iR;
            }
            if (iL > iR) break;
        }
        if (iLeft < iR) {
            MikktspaceTangentGenerator.quickSort(pSortBuffer, iLeft, iR, uSeed);
        }
        if (iL < iRight) {
            MikktspaceTangentGenerator.quickSort(pSortBuffer, iL, iRight, uSeed);
        }
    }

    static void buildNeighborsFast(TriInfo[] pTriInfos, Edge[] pEdges, int[] piTriListIn, int iNrTrianglesIn) {
        int iR;
        int iL;
        int i;
        long uSeed = 39871946L;
        for (int f = 0; f < iNrTrianglesIn; ++f) {
            for (int i2 = 0; i2 < 3; ++i2) {
                int i0 = piTriListIn[f * 3 + i2];
                int i1 = piTriListIn[f * 3 + (i2 < 2 ? i2 + 1 : 0)];
                pEdges[f * 3 + i2] = new Edge();
                pEdges[f * 3 + i2].setI0(i0 < i1 ? i0 : i1);
                pEdges[f * 3 + i2].setI1(i0 >= i1 ? i0 : i1);
                pEdges[f * 3 + i2].setF(f);
            }
        }
        MikktspaceTangentGenerator.quickSortEdges(pEdges, 0, iNrTrianglesIn * 3 - 1, 0, uSeed);
        int iEntries = iNrTrianglesIn * 3;
        int iCurStartIndex = 0;
        for (i = 1; i < iEntries; ++i) {
            if (pEdges[iCurStartIndex].getI0() == pEdges[i].getI0()) continue;
            iL = iCurStartIndex;
            iR = i - 1;
            iCurStartIndex = i;
            MikktspaceTangentGenerator.quickSortEdges(pEdges, iL, iR, 1, uSeed);
        }
        iCurStartIndex = 0;
        for (i = 1; i < iEntries; ++i) {
            if (pEdges[iCurStartIndex].getI0() == pEdges[i].getI0() && pEdges[iCurStartIndex].getI1() == pEdges[i].getI1()) continue;
            iL = iCurStartIndex;
            iR = i - 1;
            iCurStartIndex = i;
            MikktspaceTangentGenerator.quickSortEdges(pEdges, iL, iR, 2, uSeed);
        }
        for (i = 0; i < iEntries; ++i) {
            int t2;
            boolean bUnassigned_A;
            int i0 = pEdges[i].getI0();
            int i1 = pEdges[i].getI1();
            int g = pEdges[i].getF();
            int[] i0_A = new int[1];
            int[] i1_A = new int[1];
            int[] edgenum_A = new int[1];
            int[] edgenum_B = new int[1];
            int[] triList = new int[3];
            System.arraycopy(piTriListIn, g * 3, triList, 0, 3);
            MikktspaceTangentGenerator.getEdge(i0_A, i1_A, edgenum_A, triList, i0, i1);
            boolean bl = bUnassigned_A = pTriInfos[g].faceNeighbors[edgenum_A[0]] == -1;
            if (!bUnassigned_A) continue;
            int j = i + 1;
            boolean bNotFound = true;
            while (j < iEntries && i0 == pEdges[j].getI0() && i1 == pEdges[j].getI1() && bNotFound) {
                boolean bUnassigned_B;
                int[] i0_B = new int[1];
                int[] i1_B = new int[1];
                int t = pEdges[j].getF();
                System.arraycopy(piTriListIn, t * 3, triList, 0, 3);
                MikktspaceTangentGenerator.getEdge(i1_B, i0_B, edgenum_B, triList, pEdges[j].getI0(), pEdges[j].getI1());
                boolean bl2 = bUnassigned_B = pTriInfos[t].faceNeighbors[edgenum_B[0]] == -1;
                if (i0_A[0] == i0_B[0] && i1_A[0] == i1_B[0] && bUnassigned_B) {
                    bNotFound = false;
                    continue;
                }
                ++j;
            }
            if (bNotFound) continue;
            pTriInfos[g].faceNeighbors[edgenum_A[0]] = t2 = pEdges[j].getF();
            pTriInfos[t2].faceNeighbors[edgenum_B[0]] = g;
        }
    }

    static void buildNeighborsSlow(TriInfo[] pTriInfos, int[] piTriListIn, int iNrTrianglesIn) {
        for (int f = 0; f < iNrTrianglesIn; ++f) {
            for (int i = 0; i < 3; ++i) {
                if (pTriInfos[f].faceNeighbors[i] != -1) continue;
                int i0_A = piTriListIn[f * 3 + i];
                int i1_A = piTriListIn[f * 3 + (i < 2 ? i + 1 : 0)];
                boolean bFound = false;
                int t = 0;
                int j = 0;
                while (!bFound && t < iNrTrianglesIn) {
                    if (t != f) {
                        j = 0;
                        while (!bFound && j < 3) {
                            int i1_B = piTriListIn[t * 3 + j];
                            int i0_B = piTriListIn[t * 3 + (j < 2 ? j + 1 : 0)];
                            if (i0_A == i0_B && i1_A == i1_B) {
                                bFound = true;
                                continue;
                            }
                            ++j;
                        }
                    }
                    if (bFound) continue;
                    ++t;
                }
                if (!bFound) continue;
                pTriInfos[f].faceNeighbors[i] = t;
                pTriInfos[t].faceNeighbors[j] = f;
            }
        }
    }

    static void quickSortEdges(Edge[] pSortBuffer, int iLeft, int iRight, int channel, long uSeed) {
        int iElems = iRight - iLeft + 1;
        if (iElems < 2) {
            return;
        }
        if (iElems == 2) {
            if (pSortBuffer[iLeft].array[channel] > pSortBuffer[iRight].array[channel]) {
                Edge sTmp = pSortBuffer[iLeft];
                pSortBuffer[iLeft] = pSortBuffer[iRight];
                pSortBuffer[iRight] = sTmp;
            }
            return;
        }
        long t = uSeed & 0x1FL;
        t = uSeed << (int)t | uSeed >> (int)(32L - t);
        uSeed = uSeed + t + 3L;
        uSeed &= 0xFFFFFFFFL;
        int iL = iLeft;
        int iR = iRight;
        int n = iR - iL + 1;
        assert (n >= 0);
        int index = (int)(uSeed % (long)n);
        int iMid = pSortBuffer[index + iL].array[channel];
        while (true) {
            if (pSortBuffer[iL].array[channel] < iMid) {
                ++iL;
                continue;
            }
            while (pSortBuffer[iR].array[channel] > iMid) {
                --iR;
            }
            if (iL <= iR) {
                Edge sTmp = pSortBuffer[iL];
                pSortBuffer[iL] = pSortBuffer[iR];
                pSortBuffer[iR] = sTmp;
                ++iL;
                --iR;
            }
            if (iL > iR) break;
        }
        if (iLeft < iR) {
            MikktspaceTangentGenerator.quickSortEdges(pSortBuffer, iLeft, iR, channel, uSeed);
        }
        if (iL < iRight) {
            MikktspaceTangentGenerator.quickSortEdges(pSortBuffer, iL, iRight, channel, uSeed);
        }
    }

    static void getEdge(int[] i0_out, int[] i1_out, int[] edgenum_out, int[] indices, int i0_in, int i1_in) {
        edgenum_out[0] = -1;
        if (indices[0] == i0_in || indices[0] == i1_in) {
            if (indices[1] == i0_in || indices[1] == i1_in) {
                edgenum_out[0] = 0;
                i0_out[0] = indices[0];
                i1_out[0] = indices[1];
            } else {
                edgenum_out[0] = 2;
                i0_out[0] = indices[2];
                i1_out[0] = indices[0];
            }
        } else {
            edgenum_out[0] = 1;
            i0_out[0] = indices[1];
            i1_out[0] = indices[2];
        }
    }

    static void degenPrologue(TriInfo[] pTriInfos, int[] piTriList_out, int iNrTrianglesIn, int iTotTris) {
        int t = 0;
        while (t < iTotTris - 1) {
            int iFO_a = pTriInfos[t].orgFaceNumber;
            int iFO_b = pTriInfos[t + 1].orgFaceNumber;
            if (iFO_a == iFO_b) {
                boolean bIsDeg_b;
                boolean bIsDeg_a = (pTriInfos[t].flag & 1) != 0;
                boolean bl = bIsDeg_b = (pTriInfos[t + 1].flag & 1) != 0;
                if (bIsDeg_a ^ bIsDeg_b) {
                    pTriInfos[t].flag |= 2;
                    pTriInfos[t + 1].flag |= 2;
                }
                t += 2;
                continue;
            }
            ++t;
        }
        int iNextGoodTriangleSearchIndex = 1;
        t = 0;
        boolean bStillFindingGoodOnes = true;
        while (t < iNrTrianglesIn && bStillFindingGoodOnes) {
            boolean bIsGood;
            boolean bl = bIsGood = (pTriInfos[t].flag & 1) == 0;
            if (bIsGood) {
                if (iNextGoodTriangleSearchIndex < t + 2) {
                    iNextGoodTriangleSearchIndex = t + 2;
                }
            } else {
                boolean bJustADegenerate = true;
                while (bJustADegenerate && iNextGoodTriangleSearchIndex < iTotTris) {
                    boolean bIsGood2;
                    boolean bl2 = bIsGood2 = (pTriInfos[iNextGoodTriangleSearchIndex].flag & 1) == 0;
                    if (bIsGood2) {
                        bJustADegenerate = false;
                        continue;
                    }
                    ++iNextGoodTriangleSearchIndex;
                }
                int t0 = t;
                int t1 = iNextGoodTriangleSearchIndex++;
                assert (iNextGoodTriangleSearchIndex > t + 1);
                if (!bJustADegenerate) {
                    for (int i = 0; i < 3; ++i) {
                        int index = piTriList_out[t0 * 3 + i];
                        piTriList_out[t0 * 3 + i] = piTriList_out[t1 * 3 + i];
                        piTriList_out[t1 * 3 + i] = index;
                    }
                    TriInfo tri_info = pTriInfos[t0];
                    pTriInfos[t0] = pTriInfos[t1];
                    pTriInfos[t1] = tri_info;
                } else {
                    bStillFindingGoodOnes = false;
                }
            }
            if (!bStillFindingGoodOnes) continue;
            ++t;
        }
        assert (bStillFindingGoodOnes);
        assert (iNrTrianglesIn == t);
    }

    static void DegenEpilogue(TSpace[] psTspace, TriInfo[] pTriInfos, int[] piTriListIn, MikkTSpaceContext mikkTSpace, int iNrTrianglesIn, int iTotTris) {
        int t;
        for (t = iNrTrianglesIn; t < iTotTris; ++t) {
            boolean bSkip;
            boolean bl = bSkip = (pTriInfos[t].flag & 2) != 0;
            if (bSkip) continue;
            for (int i = 0; i < 3; ++i) {
                int index1 = piTriListIn[t * 3 + i];
                boolean bNotFound = true;
                int j = 0;
                while (bNotFound && j < 3 * iNrTrianglesIn) {
                    int index2 = piTriListIn[j];
                    if (index1 == index2) {
                        bNotFound = false;
                        continue;
                    }
                    ++j;
                }
                if (bNotFound) continue;
                int iTri = j / 3;
                int iVert = j % 3;
                byte iSrcVert = pTriInfos[iTri].vertNum[iVert];
                int iSrcOffs = pTriInfos[iTri].tSpacesOffs;
                byte iDstVert = pTriInfos[t].vertNum[i];
                int iDstOffs = pTriInfos[t].tSpacesOffs;
                psTspace[iDstOffs + iDstVert] = psTspace[iSrcOffs + iSrcVert];
            }
        }
        for (t = 0; t < iNrTrianglesIn; ++t) {
            if ((pTriInfos[t].flag & 2) == 0) continue;
            byte[] pV = pTriInfos[t].vertNum;
            int iFlag = 1 << pV[0] | 1 << pV[1] | 1 << pV[2];
            int iMissingIndex = 0;
            if ((iFlag & 2) == 0) {
                iMissingIndex = 1;
            } else if ((iFlag & 4) == 0) {
                iMissingIndex = 2;
            } else if ((iFlag & 8) == 0) {
                iMissingIndex = 3;
            }
            int iOrgF = pTriInfos[t].orgFaceNumber;
            Vector3f vDstP = MikktspaceTangentGenerator.getPosition(mikkTSpace, MikktspaceTangentGenerator.makeIndex(iOrgF, iMissingIndex));
            boolean bNotFound = true;
            int i = 0;
            while (bNotFound && i < 3) {
                byte iVert = pV[i];
                Vector3f vSrcP = MikktspaceTangentGenerator.getPosition(mikkTSpace, MikktspaceTangentGenerator.makeIndex(iOrgF, iVert));
                if (vSrcP.equals(vDstP)) {
                    int iOffs = pTriInfos[t].tSpacesOffs;
                    psTspace[iOffs + iMissingIndex] = psTspace[iOffs + iVert];
                    bNotFound = false;
                    continue;
                }
                ++i;
            }
            assert (!bNotFound);
        }
    }

    private static class TSpace {
        Vector3f os = new Vector3f();
        float magS;
        Vector3f ot = new Vector3f();
        float magT;
        int counter;
        boolean orient;

        private TSpace() {
        }

        void set(TSpace ts) {
            this.os.set(ts.os);
            this.magS = ts.magS;
            this.ot.set(ts.ot);
            this.magT = ts.magT;
            this.counter = ts.counter;
            this.orient = ts.orient;
        }
    }

    private static class TriInfo {
        int[] faceNeighbors = new int[3];
        Group[] assignedGroup = new Group[3];
        Vector3f os = new Vector3f();
        Vector3f ot = new Vector3f();
        float magS;
        float magT;
        int orgFaceNumber;
        int flag;
        int tSpacesOffs;
        byte[] vertNum = new byte[4];

        private TriInfo() {
        }
    }

    private static class Group {
        int nrFaces;
        List<Integer> faceIndices = new ArrayList<Integer>();
        int vertexRepresentative;
        boolean orientationPreserving;

        private Group() {
        }
    }

    private static class TmpVert {
        float[] vert = new float[3];
        int index;

        private TmpVert() {
        }
    }

    private static class Edge {
        int[] array = new int[3];

        private Edge() {
        }

        void setI0(int i) {
            this.array[0] = i;
        }

        void setI1(int i) {
            this.array[1] = i;
        }

        void setF(int i) {
            this.array[2] = i;
        }

        int getI0() {
            return this.array[0];
        }

        int getI1() {
            return this.array[1];
        }

        int getF() {
            return this.array[2];
        }
    }

    private static class SubGroup {
        int nrFaces;
        int[] triMembers;

        private SubGroup() {
        }
    }
}

