/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureArray;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3i;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewMask
implements VersionedObject<Vec3i> {
    static Logger log = LoggerFactory.getLogger(ViewMask.class);
    private Grid grid;
    private Vec3i viewRadius;
    private Vec3i size;
    private Vec3i centerWorld;
    private long version;
    private Vec3i centerCell;
    private Layer[] layers;
    private TextureArray maskTextures;
    private Image arrayImage;
    private boolean debug = false;

    public ViewMask(Grid grid, Vec3i viewRadius) {
        this.grid = grid;
        this.viewRadius = viewRadius;
        this.centerWorld = new Vec3i(0, viewRadius.y + 1, 0);
        this.size = viewRadius.mult(2).addLocal(1, 1, 1);
        ArrayList<Image> layerImages = new ArrayList<Image>();
        this.layers = new Layer[this.size.y];
        for (int i = 0; i < this.size.y; ++i) {
            this.layers[i] = new Layer(i, this.size.x, this.size.z);
            layerImages.add(this.layers[i].maskImage);
        }
        this.maskTextures = new TextureArray(layerImages);
        this.arrayImage = this.maskTextures.getImage();
        this.maskTextures.setMagFilter(Texture.MagFilter.Bilinear);
        this.maskTextures.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        if (this.debug) {
            this.testCrissCross();
        }
    }

    protected void testCrissCross() {
        for (int i = -this.viewRadius.x; i <= this.viewRadius.x; ++i) {
            for (int j = -this.viewRadius.z; j <= this.viewRadius.z; ++j) {
                for (int k = -this.viewRadius.y; k <= this.viewRadius.y; ++k) {
                    boolean visible = (i == j || -i == j) && k % 2 == 0;
                    this.markRendered(new Vec3i(i, k, j), visible);
                }
            }
        }
    }

    public void setRendered(Vec3i offset, boolean rendered) {
        if (!this.debug) {
            this.markRendered(offset, rendered);
        }
    }

    public Image getLayerImage(int layer) {
        return this.layers[layer].maskImage;
    }

    protected void markRendered(Vec3i offset, boolean rendered) {
        int x = this.viewRadius.x + offset.x;
        int y = this.viewRadius.y + offset.y;
        int z = this.viewRadius.z + offset.z;
        int c1 = z * this.size.x + x;
        this.layers[y].markRendered(c1, rendered);
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Vec3i getViewRadius() {
        return this.viewRadius;
    }

    public void setCenterWorld(Vec3i v) {
        if (this.centerWorld.equals((Object)v)) {
            return;
        }
        this.centerWorld.set(v);
        ++this.version;
    }

    public Vec3i getCenterWorld() {
        return this.centerWorld;
    }

    public Texture getMaskTextures() {
        return this.maskTextures;
    }

    public long getVersion() {
        return this.version;
    }

    public Vec3i getObject() {
        return this.centerWorld;
    }

    public VersionedReference<Vec3i> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    private class Layer {
        private int layerIndex;
        private ByteBuffer mask;
        private Image maskImage;

        public Layer(int layerIndex, int width, int height) {
            this.layerIndex = layerIndex;
            this.mask = BufferUtils.createByteBuffer((int)(width * height * 4));
            this.maskImage = new Image(Image.Format.ARGB8, width, height, this.mask, ColorSpace.Linear);
        }

        public void markRendered(int index, boolean rendered) {
            this.mask.put(index * 4 + 1, rendered ? (byte)-1 : 0);
            this.maskImage.setUpdateNeeded();
            ViewMask.this.arrayImage.setData(this.layerIndex, this.maskImage.getData(0));
        }
    }
}

