/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base.protocol;

import com.jme3.network.Message;
import com.jme3.network.base.MessageBuffer;
import com.jme3.network.base.MessageProtocol;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class LazyMessageBuffer
implements MessageBuffer {
    private MessageProtocol protocol;
    private final LinkedList<ByteBuffer> messages = new LinkedList();
    private ByteBuffer current;
    private int size;
    private Byte carry;

    public LazyMessageBuffer(MessageProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public Message pollMessage() {
        if (this.messages.isEmpty()) {
            return null;
        }
        ByteBuffer bytes = this.messages.removeFirst();
        return this.protocol.toMessage(bytes);
    }

    @Override
    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    @Override
    public boolean addBytes(ByteBuffer buffer) {
        while (buffer.remaining() > 0) {
            if (this.current == null) {
                if (this.carry != null) {
                    byte high = this.carry;
                    byte low = buffer.get();
                    this.size = (high & 0xFF) << 8 | low & 0xFF;
                    this.carry = null;
                    if (this.size < 0) {
                        throw new IllegalArgumentException("Protocol error: negative size " + this.size + " found from carry:" + high + " and low:" + low);
                    }
                } else {
                    if (buffer.remaining() < 2) {
                        this.carry = buffer.get();
                        break;
                    }
                    this.size = buffer.getShort();
                    if (this.size < 0) {
                        throw new IllegalArgumentException("Protocol error: negative size " + this.size);
                    }
                }
                this.current = ByteBuffer.allocate(this.size);
            }
            if (this.current.remaining() <= buffer.remaining()) {
                int extra = buffer.remaining() - this.current.remaining();
                buffer.limit(buffer.position() + this.current.remaining());
                this.current.put(buffer);
                this.current.flip();
                buffer.limit(buffer.position() + extra);
                this.messages.add(this.current);
                this.current = null;
                continue;
            }
            this.current.put(buffer);
        }
        return this.hasMessages();
    }
}

