/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.kernel.udp;

import com.jme3.network.kernel.Endpoint;
import com.jme3.network.kernel.Kernel;
import com.jme3.network.kernel.KernelException;
import com.jme3.network.kernel.udp.UdpKernel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class UdpEndpoint
implements Endpoint {
    private long id;
    private SocketAddress address;
    private DatagramSocket socket;
    private UdpKernel kernel;
    private boolean connected = true;

    public UdpEndpoint(UdpKernel kernel, long id, SocketAddress address, DatagramSocket socket) {
        this.id = id;
        this.address = address;
        this.socket = socket;
        this.kernel = kernel;
    }

    @Override
    public Kernel getKernel() {
        return this.kernel;
    }

    protected SocketAddress getRemoteAddress() {
        return this.address;
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean flush) {
        try {
            this.kernel.closeEndpoint(this);
            this.connected = false;
        }
        catch (IOException e) {
            throw new KernelException("Error closing endpoint for socket:" + this.socket, e);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getAddress() {
        return String.valueOf(this.address);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void send(ByteBuffer data) {
        if (!this.isConnected()) {
            throw new KernelException("Endpoint is not connected:" + this);
        }
        try {
            DatagramPacket p = new DatagramPacket(data.array(), data.position(), data.remaining(), this.address);
            this.kernel.enqueueWrite(this, p);
        }
        catch (Exception e) {
            if (e instanceof SocketException) {
                throw new KernelException("Error sending datagram to:" + this.address, e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "UdpEndpoint[" + this.id + ", " + this.address + "]";
    }
}

