/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.text.DocumentModel;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import mythruna.assembly.Joint;
import mythruna.assembly.TargetName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateJointDialog
extends Container {
    static Logger log = LoggerFactory.getLogger(CreateJointDialog.class);
    private TextField nameField;
    private VersionedReference<DocumentModel> nameRef;
    private static VersionedList<JointType> availableTypes = new VersionedList(Arrays.asList(new JointType(new TargetName("Close", "Closed"), new TargetName("Open"))));
    private Selector<JointType> jointType;
    private VersionedReference<JointType> jointTypeRef;
    private Action done;
    private Consumer<Joint> callback;
    private Joint joint;

    public CreateJointDialog() {
        super(new ElementId("dialog.window.container"));
        this.addChild((Node)new Label("New Joint", new ElementId("window.title")), new Object[0]);
        Container properties = (Container)this.addChild((Node)new Container(), new Object[0]);
        properties.addChild((Node)new Label("Name:"), new Object[0]);
        this.nameField = (TextField)properties.addChild((Node)new TextField(""), new Object[]{1});
        this.nameRef = this.nameField.getDocumentModel().createReference();
        properties.addChild((Node)new Label("Joint Type:"), new Object[0]);
        this.jointType = (Selector)properties.addChild((Node)new Selector(availableTypes), new Object[]{1});
        this.jointTypeRef = this.jointType.createSelectedItemReference();
        this.done = new CallMethodAction("Create", (Object)this, "done");
        this.done.setEnabled(false);
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton(this.done), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    public void editJoint(Joint joint, Consumer<Joint> callback) {
        this.joint = joint;
        this.callback = callback;
        this.resetFields(joint);
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this);
    }

    public void updateLogicalState(float tpf) {
        JointType type;
        super.updateLogicalState(tpf);
        if (this.nameRef.update()) {
            this.joint.setName(this.nameField.getText());
            this.done.setEnabled(this.joint.getName().length() > 0);
        }
        if (this.jointTypeRef.update() && (type = (JointType)this.jointType.getSelectedItem()) != null) {
            this.joint.setRestingState(type.start);
            this.joint.setTargetState(type.end);
        }
    }

    protected void done() {
        this.removeFromParent();
        this.callback.accept(this.joint);
    }

    protected void cancel() {
        this.removeFromParent();
    }

    protected JointType findJointType(Joint joint) {
        for (JointType type : availableTypes) {
            if (!Objects.equals(type.start, joint.getRestingState()) || !Objects.equals(type.end, joint.getTargetState())) continue;
            return type;
        }
        return null;
    }

    protected void resetFields(Joint sub) {
        this.nameField.setText(sub.getName());
        JointType type = this.findJointType(sub);
        this.jointType.getSelectionModel().clear();
        if (type != null) {
            this.jointType.setSelectedItem((Object)type);
        } else {
            this.jointType.setSelectedItem((Object)((JointType)availableTypes.get(0)));
        }
        this.done.setEnabled(sub.getName().length() > 0);
    }

    private static class JointType {
        TargetName start;
        TargetName end;

        public JointType(TargetName start, TargetName end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.end.getVerb() + "/" + this.start.getVerb();
        }
    }
}

