/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.math.Vector2f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import mythruna.client.ui.map.DefaultMapToolLayer;
import mythruna.client.ui.map.LineWidget;
import mythruna.client.ui.map.MapPoint;
import mythruna.client.ui.map.MapToolState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureToolLayer
extends DefaultMapToolLayer {
    static Logger log = LoggerFactory.getLogger(MeasureToolLayer.class);
    private MapToolState parent;
    private Node root;
    private LineWidget lineWidget;
    private VersionedReference<MapPoint> end1Ref;
    private VersionedReference<MapPoint> end2Ref;
    private MapPoint draggedEnd;
    private Vec3d dragOffset;
    private boolean widgetEnabled;
    private Label helpText;

    public MeasureToolLayer(MapToolState parent) {
        this.parent = parent;
        this.lineWidget = new LineWidget("measureTool", parent.createMapPoint(new Vec3d()), parent.createMapPoint(new Vec3d()));
        this.end1Ref = this.lineWidget.getEnd1().createReference();
        this.end2Ref = this.lineWidget.getEnd2().createReference();
        this.helpText = new Label("Measure tool tips:\nClick and drag\nto measure\ndistance.\n", new ElementId("help.tips.label"));
    }

    @Override
    protected void onActivate() {
        if (this.widgetEnabled) {
            this.parent.getToolRoot().attachChild((Spatial)this.lineWidget);
        }
        this.parent.setLayerEditor((Panel)this.helpText);
    }

    @Override
    protected void onDeactivate() {
        this.lineWidget.removeFromParent();
        this.parent.setLayerEditor(null);
    }

    @Override
    public void updateViewPort(Vector2f viewRadius) {
        this.lineWidget.setClipRadius(viewRadius);
    }

    @Override
    public void update() {
        boolean changed = false;
        if (this.end1Ref.update()) {
            changed = true;
        }
        if (this.end2Ref.update()) {
            changed = true;
        }
        if (changed) {
            this.updateText();
        }
    }

    @Override
    public void click(int button, Vec3d world, Spatial collision) {
        this.lineWidget.removeFromParent();
        this.widgetEnabled = false;
    }

    @Override
    public void startDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.parent.getToolRoot().attachChild((Spatial)this.lineWidget);
        this.widgetEnabled = true;
        this.draggedEnd = null;
        if (collision != null) {
            this.draggedEnd = this.lineWidget.findEnd(collision);
            if (this.draggedEnd != null) {
                this.dragOffset = this.draggedEnd.getWorld().subtract(start);
            } else {
                this.lineWidget.getEnd1().setWorld(start);
                this.dragOffset = new Vec3d();
                this.draggedEnd = this.lineWidget.getEnd2();
            }
            this.draggedEnd.setWorld(end.add(this.dragOffset));
        }
    }

    @Override
    public void endDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.draggedEnd = null;
    }

    @Override
    public void drag(int button, Vec3d start, Vec3d end, Spatial collision) {
        if (this.draggedEnd != null) {
            this.draggedEnd.setWorld(end.add(this.dragOffset));
        }
    }

    protected void updateText() {
        double dist = this.lineWidget.getLength();
        String s = dist < 1000.0 ? String.format("%d m", (int)Math.round(dist)) : String.format("%.02f km", dist / 1000.0);
        this.lineWidget.setText(s);
    }
}

