/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.RigidBody;
import mythruna.GameConstants;
import mythruna.sim.ai.AgentMovementInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigidBodyMover {
    static Logger log = LoggerFactory.getLogger(RigidBodyMover.class);
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;
    private RigidBody<EntityId, MBlockShape> body;
    private double mass;
    private Vec3d defaultGravity = GameConstants.DEFAULT_GRAVITY;
    private boolean flying;
    private double flight;
    private Vec3d initForce;
    private double yaw;
    private double pitch;
    private double averageYaw;
    private int windowSize = 5;
    private double yawSpeed = Math.PI * 2;
    private double pitchSpeed = Math.PI * 2;
    private Vec3d targetVelocity = new Vec3d();
    private double maxSpeed = 2.0;
    private Vec3d force = new Vec3d();

    public RigidBodyMover(RigidBody<EntityId, MBlockShape> body, boolean flying) {
        this.body = body;
        this.flying = flying;
        this.mass = 1.0 / body.getInverseMass();
        double[] angles = body.orientation.toAngles(null);
        this.yaw = angles[1];
        this.pitch = 0.0;
    }

    public void setFlying(boolean flying) {
        if (this.flying == flying) {
            return;
        }
        this.flying = flying;
        if (flying) {
            this.body.setLinearAcceleration(new Vec3d(0.0, 0.0, 0.0));
            this.initForce = new Vec3d(0.0, this.mass * 10.0, 0.0);
        } else {
            this.body.setLinearAcceleration(this.defaultGravity);
        }
    }

    public void setFlight(double flight) {
        this.flight = flight;
    }

    public void setDefaultGravity(Vec3d defaultGravity) {
        this.defaultGravity = defaultGravity;
    }

    public Vec3d getDefaultGravity() {
        return this.defaultGravity;
    }

    private double wrap(double val, double min, double max) {
        if (val < min) {
            val += max - min;
        } else if (val > max) {
            val -= max - min;
        }
        return val;
    }

    public void steer(AgentMovementInput input, Vec3d actualVelocity, boolean onGround, double step) {
        this.yaw += input.move.x * this.yawSpeed * step;
        this.yaw = this.wrap(this.yaw, 0.0, Math.PI * 2);
        this.pitch += input.move.y * this.pitchSpeed * step;
        this.pitch = this.wrap(this.pitch, -1.5707963267948966, 1.5707963267948966);
        this.averageYaw = this.yaw;
        this.body.orientation.fromAngles(this.pitch, this.averageYaw, 0.0);
        this.body.setRotationalVelocity(0.0, 0.0, 0.0);
        this.targetVelocity.set(0.0, 0.0, this.maxSpeed * input.move.z);
        if (this.targetVelocity.lengthSq() > 0.0) {
            this.body.orientation.mult(this.targetVelocity, this.targetVelocity);
        }
        double up = this.targetVelocity.y - actualVelocity.y + this.flight;
        this.force.set(this.targetVelocity).subtractLocal(actualVelocity);
        if (this.flight == 0.0) {
            this.force.y = 0.0;
            up = 0.0;
        }
        double lengthSq = this.force.lengthSq();
        if (up != 0.0 || lengthSq > 1.0E-4) {
            if (lengthSq > 1.0E-4) {
                this.force.normalizeLocal();
            } else {
                this.force.set(0.0, 0.0, 0.0);
            }
            this.force.y = up;
            this.force.multLocal(10.0 * this.mass);
            if (this.force.y != 0.0) {
                log.info("agent y force:" + this.force.y + "  target y:" + this.targetVelocity.y + " actual:" + actualVelocity.y);
            }
            this.body.addForce(this.force);
            if (this.initForce != null) {
                this.body.addForce(this.initForce);
                this.initForce = null;
            }
        }
    }
}

