/*
 * $Id$
 *
 * Copyright (c) 2024, Simsilica, LLC
 * All rights reserved.
 */


def help;
help = [
    "[command] - prints the current versions for this area or runs the optional revisions command.",
    "   where [command] is one of:",
    "  mark - sets a new base world revsion, overriding any current calculated revision.",
    "  recover - opens a revisions dialog to reset to an early version."
]
updateAdminCommand("revs", help) { args ->
    if( args ) {
        if( "mark" == args ) {
            echo("Old base revision:" + getCurrentRevision());
            markCurrentRevision();
            echo("New base revision:" + getCurrentRevision());
        } else if( "recover" == args ) {
            // Get the current column ID of the caller
            def pos = avatar[SpawnPosition].location;
            def colId = ColumnId.fromWorld(pos);

            echo("worldEntity:" + worldManager.worldEntity);
            echo("session:" + session);
            worldManager.worldEntity.run("showRevisionDialog", colId);
        } else {
            echo("Unknown revision command:" + args);
        }
    } else {
        // Get the current column ID of the caller
        def pos = avatar[SpawnPosition].location;
        def colId = ColumnId.fromWorld(pos);

        echo("Revisions for:" + colId.getWorld(null));
        int index = 1;
        getColumnRevisions(colId).each { rev ->
            echo("  " + index + ") " + String.format('%1$tF %1$tT', new Date(rev)));
            index++;
        }
    }
}


type("World").with {

    addAction("showRevisionDialog") { columnId ->
        session.showPrompt(self, PromptType.Dialog,
                            "## Revisions for:" + columnId.getWorld(null) + "\n" +
                            "Select a revision:"
                        );

        run("showRevisionOptions", columnId.getId(), 0, 10);
    }

    addAction("showRevisionOptions") { rawColumnId, page, pageSize ->

        def columnId = new ColumnId(rawColumnId);
        def revisions = getColumnRevisions(columnId);

        def opts = [];
        int index = 0;
        int first = page * pageSize;
        int last = (page + 1) * pageSize;
        revisions.each { revision ->
            if( index >= first && index < last ) {
                opts.add(new Option(self, "" + (index + 1) + ") " + String.format('%1$tF %1$tT', new Date(revision)),
                                     "revisionOption", rawColumnId, revision));
            }
            index++;
        }
        if( page > 0 ) {
            opts.add(new Option(self, "<previous>", "showRevisionOptions", rawColumnId, page-1, pageSize));
        }
        if( last < revisions.size() ) {
            opts.add(new Option(self, "<next>", "showRevisionOptions", rawColumnId, page+1, pageSize));
        }

        session.showOptions(self, opts, new Option(self, "<cancel>", "cancel"));
    }

    addAction("revisionOption") { rawColumnId, revision ->
        def columnId = new ColumnId(rawColumnId);

        // Close the dialog
        session.showPrompt(self, PromptType.Dialog, null);
        echo("Rolling:" + columnId.getWorld(null) + " back to before:" + String.format('%1$tF %1$tT', new Date(revision)));
        recoverColumnRevision(columnId, revision);
    }
}

