/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.QueryVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SphereVolume
implements QueryVolume {
    static Logger log = LoggerFactory.getLogger(SphereVolume.class);
    private final Vec3d position = new Vec3d();
    private double radius;

    public SphereVolume(Vec3d position, double radius) {
        this.position.set(position);
        this.radius = radius;
    }

    public void setPosition(Vec3d position) {
        this.position.set(position);
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public boolean intersects(Vec3d objectPosition, double objectRadius) {
        double dSq = objectPosition.distanceSq(this.position);
        double rSq = this.radius + objectRadius;
        return dSq <= (rSq *= rSq);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("position", (Object)this.position).add("radius", this.radius).toString();
    }
}

