/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.bpos.net;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.client.EntityDataClientService;
import com.simsilica.ethereal.EtherealClient;
import com.simsilica.ethereal.SharedObject;
import com.simsilica.ethereal.SharedObjectListener;
import com.simsilica.mathd.Vec3d;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObjectUpdater
extends AbstractClientService
implements SharedObjectListener {
    static Logger log = LoggerFactory.getLogger(SharedObjectUpdater.class);
    private EntityData ed;
    private EntitySet entities;
    private long frameTime;
    private Map<Long, ObjectTracker> trackers = new HashMap<Long, ObjectTracker>();

    protected void onInitialize(ClientServiceManager s) {
        log.info("onInitialize()");
        this.ed = ((EntityDataClientService)this.getService(EntityDataClientService.class)).getEntityData();
    }

    public void start() {
        log.info("start()");
        this.entities = this.ed.getEntities(new Class[]{BodyPosition.class});
        this.frameTime = -1L;
        ((EtherealClient)this.getService(EtherealClient.class)).addObjectListener((SharedObjectListener)this);
    }

    public void stop() {
        log.info("stop()");
        ((EtherealClient)this.getService(EtherealClient.class)).removeObjectListener((SharedObjectListener)this);
        this.entities.release();
    }

    public void beginFrame(long time) {
        if (log.isTraceEnabled()) {
            log.trace("** beginFrame(" + time + ")");
        }
        this.frameTime = time;
        if (this.entities.applyChanges()) {
            this.initializeBodyPosition(this.entities.getAddedEntities());
            this.initializeBodyPosition(this.entities.getChangedEntities());
            if (log.isTraceEnabled()) {
                for (Entity e : this.entities.getRemovedEntities()) {
                    log.trace("entity removed:" + e.getId());
                }
            }
            this.updateEntityTrackers(this.entities.getAddedEntities(), 1);
            this.updateEntityTrackers(this.entities.getRemovedEntities(), -1);
        }
    }

    protected void initializeBodyPosition(Set<Entity> set) {
        for (Entity e : set) {
            BodyPosition pos = (BodyPosition)e.get(BodyPosition.class);
            pos.initialize(e.getId(), 12);
            if (!log.isTraceEnabled()) continue;
            log.trace("BodyPos.initialize(" + e.getId() + ")");
        }
    }

    public void objectUpdated(SharedObject obj) {
        if (log.isTraceEnabled()) {
            log.trace("****** Object moved[t=" + this.frameTime + "]:" + obj.getEntityId() + "  pos:" + obj.getWorldPosition() + "  removed:" + obj.isMarkedRemoved());
        }
        EntityId id = new EntityId(obj.getEntityId().longValue());
        EntityId parentId = obj.getParentId() == null ? null : new EntityId(obj.getParentId().longValue());
        ObjectTracker tracker = this.getTracker(id, true);
        ++tracker.updateCount;
        Entity entity = this.entities.getEntity(id);
        if (entity == null) {
            if (tracker.updateCount > 1L && tracker.updateCount < 5L && log.isDebugEnabled()) {
                log.debug("update: No entity yet for:" + obj.getEntityId());
            } else if (tracker.updateCount == 20L) {
                log.error("update: No entity for:" + obj.getEntityId() + "  after 20 updates.");
            }
            return;
        }
        BodyPosition pos = (BodyPosition)entity.get(BodyPosition.class);
        if (pos == null) {
            if (log.isDebugEnabled()) {
                log.debug("Object doesn't have a BodyPosition yet for:" + obj.getEntityId());
            }
        } else {
            if (!pos.isInitialized()) {
                log.error("BodyPos not initialized:" + id);
                pos.initialize(id, 12);
            }
            pos.addFrame(this.frameTime, parentId, obj.getWorldPosition(), obj.getWorldRotation(), true);
        }
    }

    public void objectRemoved(SharedObject obj) {
        if (log.isDebugEnabled()) {
            log.debug("****** Object removed[t=" + this.frameTime + "]:" + obj.getEntityId() + "  netId:" + obj.getNetworkId());
        }
        EntityId id = new EntityId(obj.getEntityId().longValue());
        EntityId parentId = obj.getParentId() == null ? null : new EntityId(obj.getParentId().longValue());
        Entity entity = this.entities.getEntity(id);
        ObjectTracker tracker = this.getTracker(id, false);
        if (tracker == null) {
            log.warn("Received object removal for entity/object with no tracker:" + id);
        } else {
            ++tracker.objectRemoved;
            tracker.checkRelease();
        }
        if (entity == null) {
            log.info("Already removed");
            return;
        }
        BodyPosition pos = (BodyPosition)entity.get(BodyPosition.class);
        if (pos == null) {
            if (log.isDebugEnabled()) {
                log.debug("Removed object doesn't have a BodyPosition yet for:" + obj.getEntityId());
            }
        } else {
            Vec3d wPos;
            if (log.isDebugEnabled()) {
                log.debug("Setting entity to invisible for:" + obj.getEntityId());
            }
            if ((wPos = obj.getWorldPosition()) == null) {
                wPos = pos.getLastLocation();
                log.warn("Object:" + obj.getEntityId() + " has no position:" + entity + ", using last-known good position:" + wPos);
            }
            if (wPos == null) {
                log.error("Object:" + obj.getEntityId() + " is being removed but it has no initial position, but does have a BodyPosition:" + pos);
            } else {
                pos.addFrame(this.frameTime, parentId, obj.getWorldPosition(), obj.getWorldRotation(), false);
            }
        }
    }

    public void endFrame() {
        log.trace("** endFrame()");
        this.frameTime = -1L;
        if (log.isTraceEnabled() && this.trackers.size() != this.entities.size()) {
            log.info("Tracker count:" + this.trackers.size() + "  entity count:" + this.entities.size());
        }
    }

    protected ObjectTracker getTracker(EntityId id, boolean create) {
        return this.getTracker(id.getId(), create);
    }

    protected ObjectTracker getTracker(Long id, boolean create) {
        ObjectTracker result = this.trackers.get(id);
        if (result == null && create) {
            result = new ObjectTracker(id);
            this.trackers.put(id, result);
        }
        return result;
    }

    protected void updateEntityTrackers(Set<Entity> set, int delta) {
        for (Entity e : set) {
            if (delta > 0) {
                this.getTracker((EntityId)e.getId(), (boolean)true).entityAdded += delta;
                continue;
            }
            ObjectTracker tracker = this.getTracker(e.getId(), false);
            if (tracker == null) {
                log.warn("Receiving entity removal for entity we've never seen:" + e.getId());
                continue;
            }
            tracker.entityAdded += delta;
            tracker.checkRelease();
        }
    }

    private class ObjectTracker {
        Long id;
        int entityAdded;
        int objectRemoved;
        long updateCount;

        public ObjectTracker(Long id) {
            this.id = id;
        }

        public void checkRelease() {
            if (this.entityAdded == 0 && this.objectRemoved > 0) {
                SharedObjectUpdater.this.trackers.remove(this.id);
            } else if (this.entityAdded < 0) {
                log.warn("ObjectTracker.entityAdded somehow went negative for:" + this.id);
            }
        }
    }
}

