/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import com.simsilica.state.DebugHudState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ProgressState.class);
    private Container progressPanel;
    private Map<ProgressTracker, ProgressView> index = new HashMap<ProgressTracker, ProgressView>();
    private SafeArrayList<ProgressView> views = new SafeArrayList(ProgressView.class);
    private boolean positionInvalid;
    private VersionedReference trackers;

    protected void initialize(Application app) {
        this.trackers = ProgressTrackers.createReference();
        this.progressPanel = new Container(DebugHudState.CONTAINER_ID);
        this.updateView();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((SimpleApplication)this.getApplication()).getGuiNode().attachChild((Spatial)this.progressPanel);
        this.positionInvalid = true;
    }

    protected void onDisable() {
        this.progressPanel.removeFromParent();
    }

    public void update(float tpf) {
        if (this.trackers.update()) {
            this.updateView();
        }
        for (ProgressView view : (ProgressView[])this.views.getArray()) {
            view.update();
        }
        if (this.positionInvalid) {
            this.resetPosition();
        }
    }

    protected void resetPosition() {
        Vector3f size = this.progressPanel.getPreferredSize();
        float width = this.getApplication().getCamera().getWidth();
        this.progressPanel.setLocalTranslation(width - size.x, size.y, 100.0f);
        this.positionInvalid = false;
    }

    protected void addView(ProgressView view) {
        this.views.add((Object)view);
        this.progressPanel.addChild((Node)view.label, new Object[0]);
        this.positionInvalid = true;
    }

    protected void removeView(ProgressView view) {
        this.views.remove((Object)view);
        this.progressPanel.removeChild((Node)view.label);
        this.positionInvalid = true;
    }

    protected void updateView() {
        for (ProgressTrackers.ThreadTrackers trackers : ProgressTrackers.getThreadTrackers()) {
            for (ProgressTracker progress : trackers) {
                ProgressView view = this.index.get(progress);
                if (view != null) continue;
                view = new ProgressView(progress);
                this.index.put(progress, view);
                this.addView(view);
            }
        }
        Iterator<Map.Entry<ProgressTracker, ProgressView>> it = this.index.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ProgressTracker, ProgressView> e = it.next();
            if (!e.getKey().isClosed()) continue;
            it.remove();
            this.removeView(e.getValue());
        }
    }

    protected String progressToString(ProgressTracker progress) {
        return String.format("%s: %.02f", progress.getName(), progress.getPercent() * 100.0);
    }

    private class ProgressView {
        private VersionedReference<ProgressTracker> progress;
        private Label label;

        public ProgressView(ProgressTracker progress) {
            this.progress = progress.createReference();
            this.label = new Label(ProgressState.this.progressToString(progress), DebugHudState.VALUE_ID);
        }

        public void update() {
            if (this.progress.update()) {
                this.label.setText(ProgressState.this.progressToString((ProgressTracker)this.progress.get()));
            }
        }
    }
}

