/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.google.common.base.MoreObjects;
import com.simsilica.fractal.Sampler;
import com.simsilica.fractal.SamplerRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RidgeFractal
implements Sampler {
    static Logger log = LoggerFactory.getLogger(RidgeFractal.class);
    private Sampler noise;
    private SamplerRange range;
    private double fractalIncrement = 0.5;
    private double lacunarity = 3.02;
    private int octaves = 6;
    private double offset = 0.86;
    private double threshold = 1.5;
    private int maxOctaves = 128;
    private double[] exponents = new double[this.maxOctaves];

    public RidgeFractal(Sampler noise) {
        this.noise = noise;
        this.reinitialize();
    }

    protected void reinitialize() {
        for (int i = 0; i < this.maxOctaves; ++i) {
            this.exponents[i] = Math.pow(this.lacunarity, (double)(-i) * this.fractalIncrement);
        }
    }

    public void setFractalIncrement(double d) {
        this.fractalIncrement = d;
        this.range = null;
    }

    public double getFractalIncrement() {
        return this.fractalIncrement;
    }

    public void setLacunarity(double d) {
        this.lacunarity = d;
        this.range = null;
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public void setOctaves(int d) {
        this.octaves = d;
        this.range = null;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOffset(double d) {
        this.offset = d;
        this.range = null;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    public double getSample(double x, double y, double z) {
        double signal = this.noise.getSample(x, y, z);
        if (signal < 0.0) {
            signal = -signal;
        }
        signal = this.offset - signal;
        signal *= signal;
        double result = signal;
        double weight = 1.0;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            weight = signal * this.threshold;
            if (weight > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            if ((signal = this.noise.getSample(x, y, z)) < 0.0) {
                signal = -signal;
            }
            signal = this.offset - signal;
            signal *= signal;
            result += (signal *= weight) * this.exponents[i];
        }
        return result;
    }

    @Override
    public SamplerRange getRange() {
        if (this.range != null) {
            return this.range;
        }
        double min = this.noise.getRange().getMin();
        double max = this.noise.getRange().getMax();
        return new SamplerRange(min, max);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("noise", (Object)this.noise).add("fractalIncrement", this.fractalIncrement).add("lacunarity", this.lacunarity).add("octaves", this.octaves).add("offset", this.offset).add("threshold", this.threshold).toString();
    }
}

