/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PrimitiveType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeomPartBuilder {
    static Logger log = LoggerFactory.getLogger(GeomPartBuilder.class);
    private MaterialType materialType;
    private PrimitiveType primitiveType = PrimitiveType.Triangles;
    private int dir = -1;
    private boolean floatTexCoords;
    private List<VertexBuilder> verts = new ArrayList<VertexBuilder>();
    private List<IndexBuilder> indexes = new ArrayList<IndexBuilder>();
    private boolean hasNormals = false;
    private boolean hasTangents = false;
    private boolean hasUvs = false;
    private boolean hasColors = false;
    private boolean hasSizes = false;

    public GeomPart build() {
        GeomPart part = new GeomPart(this.materialType, this.primitiveType, this.dir, this.floatTexCoords);
        for (VertexBuilder v : this.verts) {
            if (v.normal != null) {
                this.hasNormals = true;
            }
            if (v.tangent != null) {
                this.hasTangents = true;
            }
            if (v.uv != null) {
                this.hasUvs = true;
            }
            if (v.color != null) {
                this.hasColors = true;
            }
            if (v.size == null) continue;
            this.hasSizes = true;
        }
        float[] coords = new float[this.verts.size() * 3];
        float[] normals = !this.hasNormals ? null : new float[this.verts.size() * 3];
        float[] tangents = !this.hasTangents ? null : new float[this.verts.size() * 3];
        float[] uvs = !this.hasUvs ? null : new float[this.verts.size() * 2];
        float[] colors = !this.hasColors ? null : new float[this.verts.size() * 4];
        float[] sizes = !this.hasSizes ? null : new float[this.verts.size()];
        int pos = 0;
        for (VertexBuilder vertexBuilder : this.verts) {
            int base3 = pos * 3;
            coords[base3 + 0] = (float)((VertexBuilder)vertexBuilder).coord.x;
            coords[base3 + 1] = (float)((VertexBuilder)vertexBuilder).coord.y;
            coords[base3 + 2] = (float)((VertexBuilder)vertexBuilder).coord.z;
            if (vertexBuilder.normal != null) {
                normals[base3 + 0] = (float)((VertexBuilder)vertexBuilder).normal.x;
                normals[base3 + 1] = (float)((VertexBuilder)vertexBuilder).normal.y;
                normals[base3 + 2] = (float)((VertexBuilder)vertexBuilder).normal.z;
            }
            if (vertexBuilder.tangent != null) {
                tangents[base3 + 0] = (float)((VertexBuilder)vertexBuilder).tangent.x;
                tangents[base3 + 1] = (float)((VertexBuilder)vertexBuilder).tangent.y;
                tangents[base3 + 2] = (float)((VertexBuilder)vertexBuilder).tangent.z;
            }
            if (vertexBuilder.uv != null) {
                int base2 = pos * 2;
                uvs[base2 + 0] = (float)vertexBuilder.uv[0];
                uvs[base2 + 1] = (float)vertexBuilder.uv[1];
            }
            if (vertexBuilder.color != null) {
                int base4 = pos * 4;
                colors[base3 + 0] = (float)vertexBuilder.color[0];
                colors[base3 + 1] = (float)vertexBuilder.color[1];
                colors[base3 + 2] = (float)vertexBuilder.color[2];
                colors[base3 + 3] = (float)vertexBuilder.color[3];
            }
            if (vertexBuilder.size != null) {
                sizes[pos] = (float)vertexBuilder.size.doubleValue();
            }
            ++pos;
        }
        part.setCoords(coords);
        part.setNormals(normals);
        part.setTangents(tangents);
        part.setTexCoords(uvs);
        part.setColors(colors);
        part.setSizes(sizes);
        int indexSize = 0;
        for (IndexBuilder ib : this.indexes) {
            indexSize += ib.values.length;
        }
        if (indexSize > 0) {
            short[] sArray = new short[indexSize];
            int i = 0;
            for (IndexBuilder ib : this.indexes) {
                for (int val : ib.values) {
                    sArray[i++] = (short)(ib.base + val);
                }
            }
            part.setIndexes(sArray);
        }
        return part;
    }

    public IndexBuilder indexes() {
        return this.indexes(0);
    }

    public IndexBuilder indexes(int base) {
        IndexBuilder ib = new IndexBuilder(base);
        this.indexes.add(ib);
        return ib;
    }

    public GeomPartBuilder material(MaterialType materialType) {
        this.materialType = materialType;
        return this;
    }

    public GeomPartBuilder direction(int dir) {
        this.dir = dir;
        return this;
    }

    public GeomPartBuilder primitive(PrimitiveType primitiveType) {
        this.primitiveType = primitiveType;
        return this;
    }

    public GeomPartBuilder floatTexCoords(boolean flag) {
        this.floatTexCoords = flag;
        return this;
    }

    public VertexBuilder vertex(double x, double y, double z) {
        VertexBuilder vert = new VertexBuilder(new Vec3d(x, y, z));
        this.verts.add(vert);
        return vert;
    }

    public int vertexCount() {
        return this.verts.size();
    }

    public static class VertexBuilder {
        private Vec3d coord;
        private Vec3d normal;
        private Vec3d tangent;
        private double[] uv;
        private double[] color;
        private Double size;

        public VertexBuilder(Vec3d coord) {
            this.coord = coord;
        }

        public VertexBuilder normal(double x, double y, double z) {
            this.normal = new Vec3d(x, y, z);
            return this;
        }

        public VertexBuilder tangent(double x, double y, double z) {
            this.tangent = new Vec3d(x, y, z);
            return this;
        }

        public VertexBuilder uv(double x, double y) {
            this.uv = new double[]{x, y};
            return this;
        }

        public VertexBuilder color(double r, double g, double b, double a) {
            this.color = new double[]{r, g, b, a};
            return this;
        }

        public VertexBuilder size(double x) {
            this.size = x;
            return this;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[coord:" + this.coord + ", normal:" + this.normal + "]";
        }
    }

    public static class IndexBuilder {
        private int base;
        private int[] values;

        public IndexBuilder(int base) {
            this.base = base;
        }

        public IndexBuilder set(int ... values) {
            this.values = values;
            return this;
        }
    }
}

