/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.io.UpdateableData;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import mythruna.mblock.SubstanceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstanceTypeData
implements UpdateableData<SubstanceTypeData> {
    public static final long formatVersion = 42L;
    static Logger log = LoggerFactory.getLogger(SubstanceTypeData.class);
    public int badTypeIndex;
    public SubstanceType[] types;

    public SubstanceTypeData() {
    }

    public SubstanceTypeData(SubstanceType[] types, int badTypeIndex) {
        this.types = types;
        this.badTypeIndex = badTypeIndex;
    }

    public boolean update(SubstanceTypeData update) {
        if (Arrays.equals(this.types, update.types) && this.badTypeIndex == update.badTypeIndex) {
            return false;
        }
        String updateBadType = null;
        if (update.badTypeIndex >= 0 && update.badTypeIndex < update.types.length) {
            SubstanceType st = update.types[update.badTypeIndex];
            updateBadType = st != null ? st.getName() : null;
        }
        String badType = null;
        if (this.badTypeIndex >= 0 && this.badTypeIndex < this.types.length) {
            SubstanceType st = this.types[this.badTypeIndex];
            badType = st != null ? st.getName() : null;
        }
        HashMap<String, SubstanceType> index = new HashMap<String, SubstanceType>();
        for (SubstanceType type : this.types) {
            if (type == null) continue;
            index.put(type.getName(), type);
        }
        ArrayList<SubstanceType> newTypes = new ArrayList<SubstanceType>(Arrays.asList(this.types));
        for (SubstanceType type : update.types) {
            if (type == null) continue;
            SubstanceType existing = (SubstanceType)index.get(type.getName());
            if (existing == null) {
                log.info("New type:" + type.getName());
                newTypes.add(type);
                index.put(type.getName(), type);
                continue;
            }
            if (Objects.equals(type, existing)) continue;
            log.info("Replacing:" + existing.getName());
            int i = newTypes.indexOf(existing);
            if (i < 0) {
                throw new RuntimeException("Data format error: existing type not found in type list, type:" + existing.getName());
            }
            newTypes.set(i, type);
            index.put(type.getName(), type);
        }
        if (!Objects.equals(badType, updateBadType)) {
            log.info("Updating bad type index, old type:" + badType + " new type:" + updateBadType);
            SubstanceType bad = updateBadType == null ? null : (SubstanceType)index.get(updateBadType);
            this.badTypeIndex = newTypes.indexOf(bad);
            log.info("New bad type index:" + this.badTypeIndex);
        }
        this.types = newTypes.toArray(new SubstanceType[0]);
        return true;
    }

    public static SubstanceTypeData load(InputStream rawIn) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(rawIn, 16384));){
            SubstanceTypeData result = new SubstanceTypeData();
            long version = in.readLong();
            try {
                result.types = (SubstanceType[])in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Error resolving types", e);
            }
            result.badTypeIndex = in.readInt();
            SubstanceTypeData substanceTypeData = result;
            return substanceTypeData;
        }
    }

    public static SubstanceTypeData load(String resource) throws IOException {
        URL u = SubstanceTypeData.class.getResource(resource);
        if (u == null) {
            return null;
        }
        return SubstanceTypeData.load(u.openStream());
    }

    public static SubstanceTypeData load(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        return SubstanceTypeData.load(new FileInputStream(f));
    }

    public static SubstanceTypeData fromBytes(byte[] bytes) {
        SubstanceTypeData substanceTypeData;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            SubstanceTypeData data;
            substanceTypeData = data = SubstanceTypeData.load(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error converting bytes to SubstanceTypeData", e);
            }
        }
        in.close();
        return substanceTypeData;
    }

    public static void store(SubstanceTypeData data, File f) throws IOException {
        SubstanceTypeData.store(data, new FileOutputStream(f));
    }

    public static void store(SubstanceTypeData data, OutputStream rawOut) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(rawOut);){
            out.writeLong(42L);
            out.writeObject(data.types);
            out.writeInt(data.badTypeIndex);
        }
    }

    public static byte[] toBytes(SubstanceTypeData data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            SubstanceTypeData.store(data, bos);
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting SubstanceTypeData to bytes", e);
        }
    }

    public void writeIndex(File f) throws IOException {
        FileOutputStream fOut = new FileOutputStream(f);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fOut, Charsets.UTF_8));){
            out.println("# Generated:" + String.format("%1$tF %1$tT", new Date()));
            for (int i = 0; i < this.types.length; ++i) {
                SubstanceType type = this.types[i];
                if (type == null) continue;
                out.println("[" + i + "] " + type.getName());
            }
        }
    }
}

